/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

/**
 * Authorization exception to be thrown when
 * a resouce may not be accessed. 
 *
 * @author Erik Brakkee
 */
public class AuthorizationException extends RuntimeException {
    
    private Object _resource; 
    private Operation _operation; 

    public AuthorizationException(Object aResource, Operation aOperation) {
        super("Operation '" + aOperation + "' not allowed on '" + aResource + "'");
        _resource = aResource; 
        _operation = aOperation; 
    }
    
    public Object getResource() { 
        return _resource; 
    }
    
    public Operation getOperation() { 
        return _operation;
    }
    
}
