/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

import org.wamblee.persistence.Persistent;
import org.wamblee.usermgt.User;

/**
 * Represents an authorization rule to determine whether an operation is allowed on a resource. 
 *
 * @author Erik Brakkee
 */
public interface AuthorizationRule extends Persistent {
    
    /**
     * Returns the supported object types for which this authorization rule applies.
     * This can be used by the authorization service for optimization.  
     * @return Array of supported types. 
     */
    Class[] getSupportedTypes();

    /**
     * Determines whether an operation is allowed on a certain resource. 
     * The rule implementation must be prepared to deal with resources for which it does
     * not apply. In those cases it should return {@link AuthorizationResult#UNSUPPORTED_RESOURCE}. 
     * @param aResource Resource. 
     * @param anOperation Operation. 
     * @param aUser Current user.  
     * @return Authorization result. 
     */
    AuthorizationResult isAllowed(Object aResource, Operation anOperation, User aUser);
}
