/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

import org.wamblee.persistence.AbstractPersistent;
import org.wamblee.usermgt.User;

/**
 * Checks if a user against a specific group. 
 *
 * @author Erik Brakkee
 */
public class GroupUserCondition extends AbstractPersistent implements UserCondition {
    
    /**
     * Group the user must be in. 
     */
    private String _group; 
    
    /**
     * Constructs the condition. 
     * @param aGroup Group the user must be in. 
     */
    public GroupUserCondition(String aGroup) {
        _group = aGroup; 
    }
    
    /**
     * For OR mapping. 
     *
     */
    protected GroupUserCondition() { 
        _group = null; 
    }

    /* (non-Javadoc)
     * @see org.wamblee.security.authorization.UserCondition#matches(org.wamblee.usermgt.UserAccessor)
     */
    public boolean matches(User aUser) { 
        return aUser.isInGroup(_group); 
    }

    /**
     * @return Returns the _group.
     */
    protected String getGroup() {
        return _group;
    }

    /**
     * @param _group The _group to set.
     */
    protected void setGroup(String aGroup) {
        _group = aGroup;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "GroupUserCondition(group=" + _group + ")";
    }
    
}
