/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;


/**
 * Utility to map between a list of operations and a string based
 * on the names of the operations.   
 *
 * @author Erik Brakkee
 */
public interface OperationRegistry {
  
    /**
     * Gets the supported operations for a given resource class. 
     * @param aResourceClass Resource class. 
     * @return Supported operations for that class. 
     */
    Operation[] getOperations(Class aResourceClass);
    
    /**
     * Converts a number of operations to a string. 
     * @param aOperations Operations to convert. 
     * @return String representation of the allowed operations. 
     */
    String encode(Operation[] aOperations);
    
    /**
     * Converts an operations string to an array of operations.
     * @param aResourceClass Resource class.  
     * @param aOperationsString Operations string as returned by {@link #encode(Operation[])}.
     * @return Operations array. 
     */
    Operation[] decode(Class aResourceClass, String aOperationsString);
    
    /**
     * Converts an operations string to an array of operations.
     * @param aOperationsString Operations string as returned by {@link #encode(Operation[])}.
     * @return Operations array. 
     */
    Operation[] decode(String aOperationsString);
    
}
