/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

import org.wamblee.persistence.AbstractPersistent;

/**
 * Condition to check whether a path  matches a given regula expression.
 *
 * @author Erik Brakkee
 */
public class RegexpPathCondition extends AbstractPersistent implements PathCondition {
    
    /**
     * String the path must start with. 
     */
    private String _pattern; 
    
    /**
     * Constructs the condition. 
     * @param aPattern String the path must start with. 
     */
    public RegexpPathCondition(String aPattern) { 
        _pattern = aPattern; 
    }
    
    /**
     * For OR mapping. 
     *
     */
    protected RegexpPathCondition() { 
        _pattern = null; 
    }

    /* (non-Javadoc)
     * @see org.wamblee.security.authorization.PathCondition#matches(java.lang.String)
     */
    public boolean matches(String aPath) {
        return aPath.matches(_pattern);
    }

    /**
     * @return Returns the _path.
     */
    protected String getPattern() {
        return _pattern;
    }

    /**
     * @param aPattern The _path to set.
     */
    protected void setPattern(String aPattern) {
        _pattern = aPattern;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "RegexpCondition(pattern = '" + _pattern + "')";
    }
}
