/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;


/**
 * Condition to check whether a path starts with a given string. 
 *
 * @author Erik Brakkee
 */
public class StartsWithPathCondition extends RegexpPathCondition {
    
    /**
     * Constructs the condition. 
     * @param aPath String the path must start with. 
     */
    public StartsWithPathCondition(String aPath) { 
        super( aPath + ".*"); 
    }
    
    /**
     * For OR mapping. 
     *
     */
    protected StartsWithPathCondition() { 
        super(); 
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "StartsWithPathCondition(pattern = '" + getPattern() + "')";
    }
}
