/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.security.authorization;

import org.wamblee.persistence.Persistent;
import org.wamblee.usermgt.User;

/**
 * Condition used to match a user against a specified set of users. 
 *
 * @author Erik Brakkee
 */
public interface UserCondition extends Persistent {

    /**
     * Determines if the condition matches. 
     * @param aUser user to check. 
     * @return True if the condition matches, false otherwise. 
     */
    boolean matches(User aUser);
}
