/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wamblee.security.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;

/**
 * MD5 Hex encoder. 
 *
 * @author Erik Brakkee
 */
public class Md5HexMessageDigester implements MessageDigester {
    
    /**
     * Constructs the message digester. 
     *
     */
    public Md5HexMessageDigester() {
        // Empty
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.security.MessageDigester#hash(java.lang.String)
     */
    public String hash(String aValue) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] result = digest.digest(aValue.getBytes());
            char[] charResult = Hex.encodeHex(result);
            return new String(charResult);
        } catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("MD5 not supported????");
        }
    }

}
