/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.usermgt;

import java.io.Serializable;

import org.wamblee.persistence.AbstractPersistent;

/**
 * Represents a group. 
 *
 * @author Erik Brakkee
 */
public class Group extends AbstractPersistent implements Serializable, Comparable {

    /**
     * Group name. 
     */
    private String _name;  

    /**
     * Constructs the group. 
     * @param aName
     */
    Group(String aName) {
        super();
        _name = aName; 
    }
    
    public Group(Group aGroup) { 
        super(aGroup); 
        _name = aGroup._name;
    }
    
    protected Group() { 
        super(); 
        _name = null; 
    }
    
    /**
     * Gets the name of the group. 
     * @return Group name. 
     */
    public String getName() { 
        return _name; 
    }
    
    /**
     * Sets the group name. 
     * @param aName Group name. 
     */
    void setName(String aName) {
        _name = aName; 
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object aGroup) {
        if ( !( aGroup instanceof Group )) { 
            return false; 
        }
        return _name.equals(((Group)aGroup)._name);
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return _name.hashCode(); 
    }
    
    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(T)
     */
    public int compareTo(Object aGroup) {
        return _name.compareTo(((Group)aGroup)._name);
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "Group(pk = " + getPrimaryKey() + ", name=" + _name + ")";
    }
}
