/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.usermgt;

import java.util.Set;

/**
 * Represents a set of groups. A typical implemnetation would be, a readonly implementation 
 * defined in a configuration file or a list of groups defined in a database. 
 *
 * @author Erik Brakkee
 */
public interface GroupSet {
    
    /**
     * Must be called when the group has been modified to notify the group set. 
     * @param aGroup Group that was modified. 
     */
    void groupModified(Group aGroup); 
    
    /**
     * Finds the group by name. 
     * @param aName Group name. 
     * @return Group or null if not found. 
     */
    Group find(String aName);
    
    /**
     * Determines if the group exists. 
     * @param aGroup Group. 
     * @return True iff the group exists. 
     */
    boolean contains(Group aGroup);
 
    /**
     * Adds a group. If the group already exists, the existing group set
     * is left unchanged.   
     * @param aGroup Group.
     */
    boolean add(Group aGroup);
    
    /**
     * Removes a group. If the group does not exist, this method is a no-op. 
     * @param aGroup Group to remove.
     * @return True if the group was removed, false otherwise.  
     */
    boolean remove(Group aGroup);
   
    /**
     * Returns the current groups. 
     * @return Groups. 
     */
    Set<Group> list();

    /**
     * @return The number of groups. 
     */
    int size(); 
}
