/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.usermgt;

import java.util.Set;
import java.util.TreeSet;

/**
 * In-memory group set implementation. 
 *
 * @author Erik Brakkee
 */
public class InMemoryGroupSet implements GroupSet {
    
    /**
     * Groups. 
     */
    private Set<Group> _groups; 
    
    /**
     * Constructs an empty group set. 
     */
    public InMemoryGroupSet() { 
        _groups = new TreeSet<Group>();
    }
    
    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#groupModified(org.wamblee.usermgt.Group)
     */
    public void groupModified(Group aGroup) {
        _groups.remove(aGroup); 
        _groups.add(aGroup);
    }

    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#find(java.lang.String)
     */
    public Group find(String aName) {
        for (Group group: _groups) { 
            if ( group.getName().equals(aName)) { 
                return new Group(group);
            }
        }
        return null; 
    }

    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#contains(org.wamblee.usermgt.Group)
     */
    public boolean contains(Group aGroup) {
        return _groups.contains(aGroup);
    }

    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#add(org.wamblee.usermgt.Group)
     */
    public boolean add(Group aGroup) {
        return _groups.add(aGroup);
    }

    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#remove(org.wamblee.usermgt.Group)
     */
    public boolean remove(Group aGroup) {
        return _groups.remove(aGroup);
    }

    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#list()
     */
    public Set<Group> list() {
        Set<Group> list = new TreeSet<Group>(); 
        for (Group group: _groups) { 
            list.add(new Group(group));
        }
        return list;
    }
    
    /* (non-Javadoc)
     * @see org.wamblee.usermgt.GroupSet#size()
     */
    public int size() {
        return _groups.size(); 
    }

}
