/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.usermgt;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import net.sf.ehcache.Ehcache;

import org.hibernate.SessionFactory;
import org.wamblee.cache.EhCache;
import org.wamblee.system.core.DefaultProvidedInterface;
import org.wamblee.system.core.DefaultRequiredInterface;
import org.wamblee.system.core.ProvidedInterface;
import org.wamblee.system.core.RequiredInterface;
import org.wamblee.system.spring.SpringComponent;

public class UserGroupRepositoryComponent extends SpringComponent {

    public UserGroupRepositoryComponent(String aName) { 
        super(aName, new String[] { "spring/org.wamblee.security.usermgt-repositories.xml" } , 
                createProvided(), createRequired()); 
        
    }

    private static Map<RequiredInterface, String> createRequired() {
        Map<RequiredInterface, String> required = new HashMap<RequiredInterface, String>();
        required.put(new DefaultRequiredInterface("sessionFactory", SessionFactory.class), "sessionFactory");
        return required;
    }

    private static Map<String, ProvidedInterface> createProvided() {
        Map<String,ProvidedInterface> provided = new HashMap<String,ProvidedInterface>();
        provided.put("userCache", new DefaultProvidedInterface("cache", EhCache.class));
        provided.put(UserSet.class.getName(), new DefaultProvidedInterface("userset", UserSet.class));
        provided.put(GroupSet.class.getName(), new DefaultProvidedInterface("groupset", GroupSet.class));
        return provided; 
    }
    
    
}
