/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.usermgt.hibernate;

import java.io.IOException;

import javax.sql.DataSource;

import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.wamblee.cache.EhCache;
import org.wamblee.system.adapters.DefaultContainer;
import org.wamblee.system.adapters.ObjectConfiguration;
import org.wamblee.system.components.ORMappingConfig;
import org.wamblee.system.core.Component;
import org.wamblee.system.core.DefaultProvidedInterface;
import org.wamblee.system.core.DefaultRequiredInterface;
import org.wamblee.system.core.ProvidedInterface;
import org.wamblee.system.core.Scope;
import org.wamblee.system.spring.component.HibernateComponent;
import org.wamblee.usermgt.UserAdministration;
import org.wamblee.usermgt.UserGroupRepositoryComponent;

public class UserAdministrationComponent extends DefaultContainer {

    private ProvidedInterface TRANSACTION_MGR = new DefaultProvidedInterface(
            "transactionManager", PlatformTransactionManager.class);
    private ProvidedInterface USER_CACHE = new DefaultProvidedInterface(
            "userCache", EhCache.class);
    private ProvidedInterface HIBERNATE_TEMPLATE = new DefaultProvidedInterface(
            "hibernateTemplate", HibernateTemplate.class);
    private ProvidedInterface USER_MGT = new DefaultProvidedInterface(
            "usermgt", UserAdministration.class);

    public UserAdministrationComponent(String aName, boolean aExposeInternals)
            throws IOException {
        super(aName);
        
        ObjectConfiguration mappingFilesConfig = new ObjectConfiguration(UsermgtHibernateMappingFiles.class); 
        mappingFilesConfig.getSetterConfig().initAllSetters();
        addComponent("mappingFiles", new UsermgtHibernateMappingFiles(), mappingFilesConfig);

        Component<?> _hibernate = new HibernateComponent("hibernate");
        addComponent(_hibernate);

        Component<?> _repository = new UserGroupRepositoryComponent("usersgroups");
        addComponent(_repository);

        Component<?> _usermgt = new UserAdministrationLightComponent("usermgtlight");
        addComponent(_usermgt);

        addRequiredInterface(new DefaultRequiredInterface("datasource",
                DataSource.class));
        addRequiredInterface(new DefaultRequiredInterface("ormconfig", ORMappingConfig.class));

        if (aExposeInternals) {
            addProvidedInterface(TRANSACTION_MGR);
            addProvidedInterface(USER_CACHE);
            addProvidedInterface(HIBERNATE_TEMPLATE);
        }
        addProvidedInterface(USER_MGT);
    }
}
