/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.usermgt.hibernate;

import java.util.HashMap;
import java.util.Map;

import org.wamblee.system.core.DefaultProvidedInterface;
import org.wamblee.system.core.DefaultRequiredInterface;
import org.wamblee.system.core.ProvidedInterface;
import org.wamblee.system.core.RequiredInterface;
import org.wamblee.system.spring.SpringComponent;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.UserAdministration;
import org.wamblee.usermgt.UserSet;

/**
 * Light version of the user administration component that requires external
 * datasource, and userset and group set components, as well as an external
 * hibernate session factory. 
 * @author Erik Brakkee
 *
 */
public class UserAdministrationLightComponent extends SpringComponent {

    public UserAdministrationLightComponent(String aName) { 
        super(aName, new String[] { "spring/org.wamblee.security.usermgt.xml" },
                createProvided(), createRequired() );    
    }

    private static Map<RequiredInterface, String> createRequired() {
        Map<RequiredInterface, String> required = new HashMap<RequiredInterface,String>();
        required.put(new DefaultRequiredInterface("userSet", UserSet.class), UserSet.class.getName());
        required.put(new DefaultRequiredInterface("groupSet", GroupSet.class), GroupSet.class.getName());
        return required; 
    }

    private static Map<String, ProvidedInterface> createProvided() {
        Map<String, ProvidedInterface> provided = new HashMap<String, ProvidedInterface>();
        provided.put(UserAdministration.class.getName(), new DefaultProvidedInterface("org.wamblee.usermgt.UserAdministration",
                UserAdministration.class));
        return provided;
    }
}
