/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import junit.framework.TestCase;
import org.wamblee.security.authorization.AllOperation;
import org.wamblee.security.authorization.AuthorizationResult;
import org.wamblee.security.authorization.AuthorizationRule;
import org.wamblee.security.authorization.AuthorizationService;
import org.wamblee.security.authorization.CreateOperation;
import org.wamblee.security.authorization.DefaultAuthorizationService;
import org.wamblee.security.authorization.DeleteOperation;
import org.wamblee.security.authorization.Operation;
import org.wamblee.security.authorization.ReadOperation;
import org.wamblee.security.authorization.TestAuthorizationRule;
import org.wamblee.security.authorization.TestResource;
import org.wamblee.security.authorization.TestUserAccessor;
import org.wamblee.security.authorization.WriteOperation;
import org.wamblee.usermgt.UserAccessor;

public class AuthorizationServiceTest
extends TestCase {
    private AuthorizationRule _rule1;
    private AuthorizationRule _rule2;
    private AuthorizationRule _rule3;
    private AuthorizationService _service;

    protected AuthorizationService getService() {
        return this._service;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._rule1 = this.createRule(AuthorizationResult.GRANTED, "users", "/oni/", AllOperation.class);
        this._rule2 = this.createRule(AuthorizationResult.DENIED, "users", "/abc/", ReadOperation.class);
        this._rule3 = this.createRule(AuthorizationResult.GRANTED, "users", "/abc/", AllOperation.class);
        this._service = this.createService();
        this._service.appendRule(this._rule1);
        this._service.appendRule(this._rule2);
        this._service.appendRule(this._rule3);
    }

    protected void resetTestRules() {
        ((TestAuthorizationRule)this._rule1).reset();
        ((TestAuthorizationRule)this._rule2).reset();
        ((TestAuthorizationRule)this._rule3).reset();
    }

    protected UserAccessor createUserAccessor() {
        return new TestUserAccessor();
    }

    protected AuthorizationService createService() {
        DefaultAuthorizationService service = new DefaultAuthorizationService();
        service.setUserAccessor(this.createUserAccessor());
        return service;
    }

    protected AuthorizationRule createRule(AuthorizationResult aResult, String aGroup, String aPath, Class<? extends Operation> aOperation) {
        return new TestAuthorizationRule(aResult, aGroup, aPath, aOperation);
    }

    protected void checkMatchCount(int aCount, AuthorizationRule aRule) {
        AuthorizationServiceTest.assertEquals((int)aCount, (int)((TestAuthorizationRule)aRule).getMatchCount());
    }

    protected Object createResource(String aPath) {
        return new TestResource(aPath);
    }

    protected void checkRuleCount(int aCount) {
    }

    public void testFirstRuleGrants() {
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/oni/xyz.jpg"), (Operation)new ReadOperation()));
        this.checkMatchCount(1, this._rule1);
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/oni/xyz.jpg"), (Operation)new WriteOperation()));
        this.checkMatchCount(2, this._rule1);
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/oni/xyz.jpg"), (Operation)new DeleteOperation()));
        this.checkMatchCount(3, this._rule1);
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/oni/xyz.jpg"), (Operation)new CreateOperation()));
        this.checkMatchCount(4, this._rule1);
        this.checkMatchCount(0, this._rule2);
        this.checkMatchCount(0, this._rule3);
    }

    public void testSecondRuleDenies() {
        AuthorizationServiceTest.assertFalse((boolean)this._service.isAllowed(this.createResource("/abc/xyz.jpg"), (Operation)new ReadOperation()));
        this.checkMatchCount(0, this._rule1);
        this.checkMatchCount(1, this._rule2);
        this.checkMatchCount(0, this._rule3);
    }

    public void testThirdRuleGrants() {
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/abc/xyz.jpg"), (Operation)new WriteOperation()));
        this.checkMatchCount(0, this._rule1);
        this.checkMatchCount(0, this._rule2);
        this.checkMatchCount(1, this._rule3);
    }

    public void testRemoveRule() {
        this.checkRuleCount(3);
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/abc/xyz.jpg"), (Operation)new WriteOperation()));
        this._service.removeRule(2);
        AuthorizationServiceTest.assertFalse((boolean)this._service.isAllowed(this.createResource("/abc/xyz.jpg"), (Operation)new WriteOperation()));
        this.checkRuleCount(2);
    }

    public void testInsertRule() {
        this.checkRuleCount(3);
        AuthorizationServiceTest.assertFalse((boolean)this._service.isAllowed(this.createResource("/janse/xyz.jpg"), (Operation)new WriteOperation()));
        this._service.appendRule(this.createRule(AuthorizationResult.GRANTED, "users", "/janse/", WriteOperation.class));
        AuthorizationServiceTest.assertTrue((boolean)this._service.isAllowed(this.createResource("/janse/xyz.jpg"), (Operation)new WriteOperation()));
        this.checkRuleCount(4);
    }

    public void testGetRules() {
        AuthorizationRule[] rules = this._service.getRules();
        AuthorizationServiceTest.assertEquals((int)3, (int)rules.length);
    }

    public void testNoRulesSupportResource() {
        AuthorizationServiceTest.assertFalse((boolean)this._service.isAllowed(this.createResource("/xyxyxyxy"), (Operation)new ReadOperation()));
        this.checkMatchCount(0, this._rule1);
        this.checkMatchCount(0, this._rule2);
        this.checkMatchCount(0, this._rule3);
    }
}

