/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import junit.framework.TestCase;
import org.wamblee.security.authorization.AllOperation;
import org.wamblee.security.authorization.CreateOperation;
import org.wamblee.security.authorization.DefaultOperationRegistry;
import org.wamblee.security.authorization.DeleteOperation;
import org.wamblee.security.authorization.Operation;
import org.wamblee.security.authorization.OperationRegistry;
import org.wamblee.security.authorization.ReadOperation;
import org.wamblee.security.authorization.WriteOperation;

public class DefaultOperationRegistryTest
extends TestCase {
    private OperationRegistry _registry;

    protected void setUp() throws Exception {
        this._registry = new DefaultOperationRegistry(new Operation[]{new AllOperation(), new ReadOperation(), new WriteOperation(), new DeleteOperation(), new CreateOperation()});
    }

    public void testEncodeDecodeNooperations() {
        DefaultOperationRegistryTest.assertEquals((String)"", (String)this._registry.encode(new Operation[0]));
        DefaultOperationRegistryTest.assertEquals((int)0, (int)this._registry.decode(Object.class, "").length);
    }

    public void testEncode() {
        DefaultOperationRegistryTest.assertEquals((String)"read,write", (String)this._registry.encode(new Operation[]{new ReadOperation(), new WriteOperation()}));
    }

    public void testDecode() {
        Operation[] operations = this._registry.decode(Object.class, "read,write");
        DefaultOperationRegistryTest.assertTrue((boolean)(operations[0] instanceof ReadOperation));
        DefaultOperationRegistryTest.assertTrue((boolean)(operations[1] instanceof WriteOperation));
    }

    public void testDecodeUnknownOperation() {
        try {
            this._registry.decode(Object.class, "bla");
            DefaultOperationRegistryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

