/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import org.wamblee.security.authorization.AuthorizationResult;
import org.wamblee.security.authorization.GroupUserCondition;
import org.wamblee.security.authorization.IsaOperationCondition;
import org.wamblee.security.authorization.Operation;
import org.wamblee.security.authorization.OperationCondition;
import org.wamblee.security.authorization.PathCondition;
import org.wamblee.security.authorization.StartsWithPathCondition;
import org.wamblee.security.authorization.TestResource;
import org.wamblee.security.authorization.UrlAuthorizationRule;
import org.wamblee.security.authorization.UserCondition;
import org.wamblee.usermgt.User;

public class TestAuthorizationRule
extends UrlAuthorizationRule {
    private int _matches = 0;

    public TestAuthorizationRule(AuthorizationResult aResult, String aGroup, String aPath, Class<? extends Operation> aOperation) {
        super(aResult, (UserCondition)new GroupUserCondition(aGroup), (PathCondition)new StartsWithPathCondition(aPath), TestResource.class, (OperationCondition)new IsaOperationCondition(aOperation));
    }

    protected TestAuthorizationRule() {
    }

    protected String getResourcePath(Object aResource) {
        return ((TestResource)aResource).getPath();
    }

    public AuthorizationResult isAllowed(Object aResource, Operation anOperation, User aUser) {
        AuthorizationResult result = super.isAllowed(aResource, anOperation, aUser);
        if (result.equals((Object)AuthorizationResult.GRANTED) || result.equals((Object)AuthorizationResult.DENIED)) {
            ++this._matches;
        }
        return result;
    }

    public int getMatchCount() {
        return this._matches;
    }

    public void reset() {
        this._matches = 0;
    }
}

