/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import junit.framework.TestCase;
import org.wamblee.security.encryption.Md5HexMessageDigester;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.InMemoryGroupSet;
import org.wamblee.usermgt.InMemoryUserSet;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.RegexpNameValidator;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserAccessor;
import org.wamblee.usermgt.UserAdministrationImpl;
import org.wamblee.usermgt.UserMgtException;
import org.wamblee.usermgt.UserSet;

public class TestUserAccessor
implements UserAccessor {
    private static final String USER = "erik";
    private static final String PASSWORD = "abc123";
    private static final String GROUP = "users";

    public User getCurrentUser() {
        UserAdministrationImpl admin = new UserAdministrationImpl((UserSet)new InMemoryUserSet((NameValidator)new RegexpNameValidator(".{6}.*", UserMgtException.Reason.INVALID_PASSWORD, "Password must contain at least 6 characters"), (MessageDigester)new Md5HexMessageDigester()), (GroupSet)new InMemoryGroupSet(), (NameValidator)new RegexpNameValidator("[a-zA-Z]+[a-zA-Z0-9]*", UserMgtException.Reason.INVALID_USERNAME, "Invalid user"), (NameValidator)new RegexpNameValidator("[a-zA-Z]+[a-zA-Z0-9]*", UserMgtException.Reason.INVALID_GROUPNAME, "Invalid group"));
        try {
            Group group = admin.createGroup(GROUP);
            return admin.createUser(USER, PASSWORD, group);
        }
        catch (UserMgtException e) {
            TestCase.fail((String)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

