/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import junit.framework.TestCase;
import org.wamblee.security.authorization.AuthorizationResult;
import org.wamblee.security.authorization.Operation;
import org.wamblee.security.authorization.ReadOperation;
import org.wamblee.security.authorization.TestAuthorizationRule;
import org.wamblee.security.authorization.TestResource;
import org.wamblee.security.authorization.TestUserAccessor;
import org.wamblee.security.authorization.WriteOperation;
import org.wamblee.usermgt.User;

public class UrlAuthorizationRuleTest
extends TestCase {
    public void testConstructWithUndecidedResult() {
        try {
            new TestAuthorizationRule(AuthorizationResult.UNDECIDED, "users", "/path", ReadOperation.class);
            UrlAuthorizationRuleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructWithUnsupportedResult() {
        try {
            new TestAuthorizationRule(AuthorizationResult.UNSUPPORTED_RESOURCE, "users", "/path", ReadOperation.class);
            UrlAuthorizationRuleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnsupportedObject() {
        TestAuthorizationRule rule = new TestAuthorizationRule(AuthorizationResult.GRANTED, "users", "/path", ReadOperation.class);
        UrlAuthorizationRuleTest.assertEquals((Object)AuthorizationResult.UNSUPPORTED_RESOURCE, (Object)rule.isAllowed("hello", (Operation)new ReadOperation(), new TestUserAccessor().getCurrentUser()));
    }

    public void testMatchingScenarios() {
        TestAuthorizationRule rule = new TestAuthorizationRule(AuthorizationResult.GRANTED, "users", "/path/", ReadOperation.class);
        User user = new TestUserAccessor().getCurrentUser();
        UrlAuthorizationRuleTest.assertEquals((Object)AuthorizationResult.GRANTED, (Object)rule.isAllowed(new TestResource("/path/a"), (Operation)new ReadOperation(), user));
        UrlAuthorizationRuleTest.assertEquals((Object)AuthorizationResult.GRANTED, (Object)rule.isAllowed(new TestResource("/path/"), (Operation)new ReadOperation(), user));
        UrlAuthorizationRuleTest.assertEquals((Object)AuthorizationResult.UNDECIDED, (Object)rule.isAllowed(new TestResource("/path"), (Operation)new ReadOperation(), user));
        UrlAuthorizationRuleTest.assertEquals((Object)AuthorizationResult.UNDECIDED, (Object)rule.isAllowed(new TestResource("/path/"), (Operation)new WriteOperation(), user));
        TestAuthorizationRule rule2 = new TestAuthorizationRule(AuthorizationResult.GRANTED, "users2", "/path/", ReadOperation.class);
        UrlAuthorizationRuleTest.assertEquals((Object)AuthorizationResult.UNDECIDED, (Object)rule2.isAllowed(new TestResource("/path/a"), (Operation)new ReadOperation(), user));
    }
}

