/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization.hibernate;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.wamblee.security.authorization.AuthorizationService;
import org.wamblee.security.authorization.AuthorizationServiceTest;
import org.wamblee.security.authorization.TestUserAccessor;
import org.wamblee.security.authorization.hibernate.AuthorizationMappingFiles;
import org.wamblee.security.authorization.hibernate.PersistentAuthorizationService;
import org.wamblee.system.adapters.ClassConfiguration;
import org.wamblee.system.adapters.DefaultContainer;
import org.wamblee.system.adapters.ObjectConfiguration;
import org.wamblee.system.components.DatabaseComponentFactory;
import org.wamblee.system.container.Container;
import org.wamblee.system.core.Component;
import org.wamblee.system.core.Scope;
import org.wamblee.system.spring.component.DatabaseTesterComponent;
import org.wamblee.system.spring.component.DatasourceComponent;
import org.wamblee.usermgt.UserAccessor;
import org.wamblee.usermgt.hibernate.AuthorizationComponent;

public class PersistentAuthorizationServiceTest
extends AuthorizationServiceTest {
    private static final Logger LOGGER = Logger.getLogger(PersistentAuthorizationServiceTest.class);
    private static final String SERVICE_TABLE = "AUTHORIZATION_SERVICE";
    private static final String RULES_TABLE = "AUTHORIZATION_RULES";
    private static final String SERVICE_RULES_TABLE = "AUTHORIZATION_SERVICE_RULES";
    private static final String OPERATIONCOND_TABLE = "OPERATION_CONDITIONS";
    private static final String PATHCOND_TABLE = "PATH_CONDITIONS";
    private static final String USERCOND_TABLE = "USER_CONDITIONS";
    private DefaultContainer _container;
    private Scope _scope;
    private DatabaseTesterComponent _databaseTester;
    private UserAccessor _userAccessor;
    private HibernateTemplate _hibernateTemplate;
    private AuthorizationService _authorizationService;

    @Override
    protected void setUp() throws Exception {
        this._container = new DefaultContainer("top");
        DatabaseComponentFactory.addDatabaseConfig((Container)this._container);
        this._container.addComponent((Component)new DatasourceComponent("datasource"));
        ClassConfiguration useraccessorConfig = new ClassConfiguration(TestUserAccessor.class);
        useraccessorConfig.getObjectConfig().getSetterConfig().initAllSetters();
        this._container.addComponent("userAccessor", useraccessorConfig);
        this._container.addComponent((Component)new AuthorizationComponent("authorization", true));
        ClassConfiguration dbtesterConfig = new ClassConfiguration(DatabaseTesterComponent.class);
        dbtesterConfig.getObjectConfig().getSetterConfig().initAllSetters();
        this._container.addComponent("databaseTester", dbtesterConfig);
        ObjectConfiguration config = new ObjectConfiguration(PersistentAuthorizationServiceTest.class);
        config.getSetterConfig().clear().add("setUserAccessor").add("setDatabaseTester").add("setHibernateTemplate").add("setAuthorizationService");
        this._container.addComponent("testcase", (Object)this, config);
        this._scope = this._container.start();
        this._databaseTester.cleanDatabase();
        super.setUp();
    }

    public void setDatabaseTester(DatabaseTesterComponent aDatabaseTester) {
        this._databaseTester = aDatabaseTester;
    }

    public void setUserAccessor(UserAccessor aUserAccessor) {
        this._userAccessor = aUserAccessor;
    }

    public void setHibernateTemplate(HibernateTemplate aHibernateTemplate) {
        this._hibernateTemplate = aHibernateTemplate;
    }

    public void setAuthorizationService(AuthorizationService aAuthorizationService) {
        this._authorizationService = aAuthorizationService;
    }

    @Override
    protected AuthorizationService createService() {
        PersistentAuthorizationService service = new PersistentAuthorizationService("DEFAULT", this._hibernateTemplate, this.createUserAccessor(), 10000L);
        return service;
    }

    @Override
    protected void checkRuleCount(int aCount) {
        try {
            PersistentAuthorizationServiceTest.assertEquals((int)1, (int)this._databaseTester.getTableSize(SERVICE_TABLE));
            PersistentAuthorizationServiceTest.assertEquals((int)aCount, (int)this._databaseTester.getTableSize(RULES_TABLE));
            PersistentAuthorizationServiceTest.assertEquals((int)aCount, (int)this._databaseTester.getTableSize(SERVICE_RULES_TABLE));
            PersistentAuthorizationServiceTest.assertEquals((int)aCount, (int)this._databaseTester.getTableSize(USERCOND_TABLE));
            PersistentAuthorizationServiceTest.assertEquals((int)aCount, (int)this._databaseTester.getTableSize(PATHCOND_TABLE));
            PersistentAuthorizationServiceTest.assertEquals((int)aCount, (int)this._databaseTester.getTableSize(OPERATIONCOND_TABLE));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void testSchemaExport() {
        Configuration config = new Configuration();
        for (String mappingFile : new AuthorizationMappingFiles()) {
            config.addResource(mappingFile);
        }
        config.setProperty("hibernate.dialect", MySQL5InnoDBDialect.class.getName());
        SchemaExport exporter = new SchemaExport(config);
        exporter.setOutputFile("target/mysql5.schema.sql");
        exporter.create(true, false);
    }

    public void testPerformance() {
        PersistentAuthorizationService service = (PersistentAuthorizationService)this.getService();
        int n = 1000;
        long time = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            this.testFirstRuleGrants();
            this.resetTestRules();
            this.testSecondRuleDenies();
            this.resetTestRules();
            this.testThirdRuleGrants();
            this.resetTestRules();
            this.testNoRulesSupportResource();
        }
        LOGGER.info((Object)("Executed " + 4 * n + " authorization checks in " + (float)(System.currentTimeMillis() - time) / 1000.0f + " seconds."));
    }
}

