/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Set;
import junit.framework.TestCase;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.InMemoryGroupSet;

public class InMemoryGroupSetTest
extends TestCase {
    protected GroupSet _groups;

    protected GroupSet createGroupSet() {
        return new InMemoryGroupSet();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._groups = this.createGroupSet();
        this.checkGroupCount(0);
    }

    protected void checkGroupExists(String aGroup) throws SQLException {
    }

    protected void checkGroupNotExists(String aGroup) throws SQLException {
    }

    protected void checkGroupCount(int aSize) throws SQLException {
        InMemoryGroupSetTest.assertEquals((int)aSize, (int)this._groups.size());
    }

    public void testAdd() throws SQLException {
        Group group = new Group("group1");
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.add(group));
        this.checkGroupExists(group.getName());
        this.checkGroupCount(1);
        Group group2 = this._groups.find("group1");
        InMemoryGroupSetTest.assertNotNull((Object)group2);
        InMemoryGroupSetTest.assertEquals((String)group.getName(), (String)group2.getName());
        Set set = this._groups.list();
        InMemoryGroupSetTest.assertEquals((int)1, (int)set.size());
        InMemoryGroupSetTest.assertTrue((boolean)set.contains(group));
    }

    public void testFindUnknownGroup() throws SQLException {
        Group group1 = new Group("group1");
        Group group2 = new Group("group2");
        this._groups.add(group1);
        this._groups.add(group2);
        this.checkGroupExists(group1.getName());
        this.checkGroupExists(group2.getName());
        InMemoryGroupSetTest.assertNull((Object)this._groups.find("group3"));
        this.checkGroupNotExists("group3");
    }

    public void testAddDuplicateGroup() throws SQLException {
        Group group1 = new Group("group1");
        this._groups.add(group1);
        InMemoryGroupSetTest.assertEquals((int)1, (int)this._groups.list().size());
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.contains(group1));
        group1 = new Group("group1");
        InMemoryGroupSetTest.assertFalse((boolean)this._groups.add(group1));
        InMemoryGroupSetTest.assertEquals((int)1, (int)this._groups.list().size());
        this.checkGroupExists(group1.getName());
        this.checkGroupCount(1);
    }

    public void testRemoveGroup() throws SQLException {
        Group group1 = new Group("group1");
        this._groups.add(group1);
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.contains(group1));
        this.checkGroupCount(1);
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.remove(group1));
        InMemoryGroupSetTest.assertFalse((boolean)this._groups.contains(group1));
        InMemoryGroupSetTest.assertNull((Object)this._groups.find(group1.getName()));
        InMemoryGroupSetTest.assertEquals((int)0, (int)this._groups.list().size());
        this.checkGroupCount(0);
    }

    public void testRemoveNonExistingGroup() throws SQLException {
        Group group1 = new Group("group1");
        this._groups.add(group1);
        this.checkGroupCount(1);
        Group nonExistingGroup = new Group("group2");
        nonExistingGroup.setPrimaryKey((Serializable)new Long(1000L));
        nonExistingGroup.setPersistedVersion(1000);
        InMemoryGroupSetTest.assertFalse((boolean)this._groups.remove(nonExistingGroup));
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.contains(group1));
        InMemoryGroupSetTest.assertEquals((int)1, (int)this._groups.list().size());
        this.checkGroupCount(1);
    }

    public void testList() throws SQLException {
        Group group1 = new Group("group1");
        Group group2 = new Group("group2");
        Group group3 = new Group("group3");
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.add(group1));
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.add(group2));
        InMemoryGroupSetTest.assertTrue((boolean)this._groups.add(group3));
        this.checkGroupExists(group1.getName());
        this.checkGroupExists(group2.getName());
        this.checkGroupExists(group3.getName());
        Set set = this._groups.list();
        InMemoryGroupSetTest.assertTrue((boolean)set.contains(group1));
        InMemoryGroupSetTest.assertTrue((boolean)set.contains(group2));
        InMemoryGroupSetTest.assertTrue((boolean)set.contains(group3));
        this.checkGroupCount(3);
    }
}

