/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Set;
import junit.framework.TestCase;
import org.wamblee.security.encryption.Md5HexMessageDigester;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.InMemoryGroupSet;
import org.wamblee.usermgt.InMemoryUserSet;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.RegexpNameValidator;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserMgtException;
import org.wamblee.usermgt.UserSet;
import org.wamblee.usermgt.UsermgtTestUtils;

public class InMemoryUserSetTest
extends TestCase {
    protected static final String PASSWORD = "abc123";
    private UserSet _users;
    private GroupSet _groups;
    private Group _group;

    protected UserSet createUserSet() {
        return new InMemoryUserSet((NameValidator)new RegexpNameValidator(".{6}.*", UserMgtException.Reason.INVALID_PASSWORD, "Password must contain at least 6 characters"), (MessageDigester)new Md5HexMessageDigester());
    }

    protected GroupSet createGroupSet() {
        return new InMemoryGroupSet();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._users = this.createUserSet();
        this._groups = this.createGroupSet();
        this._group = new Group("group0");
        this._groups.add(this._group);
        this.checkUserCount(0);
    }

    protected UserSet getUsers() {
        return this._users;
    }

    protected GroupSet getGroups() {
        return this._groups;
    }

    protected Group createGroup(String aName) {
        return new Group(aName);
    }

    protected User createUser(String aName, String aPassword, Group aGroup) throws UserMgtException {
        return UsermgtTestUtils.createUser(aName, aPassword, aGroup);
    }

    protected void addUserToGroup(User aUser, Group aGroup) throws UserMgtException {
        aUser.addGroup(aGroup);
    }

    protected void removeUserFromGroup(User aUser, Group aGroup) throws UserMgtException {
        aUser.removeGroup(aGroup);
    }

    protected void checkUserExists(String aUser) throws SQLException {
    }

    protected void checkUserNotExists(String aUser) throws SQLException {
    }

    protected void checkUserCount(int aSize) throws SQLException {
        InMemoryUserSetTest.assertEquals((int)aSize, (int)this._users.size());
    }

    protected void checkGroupExists(String aUser) throws SQLException {
    }

    protected void checkGroupNotExists(String aUser) throws SQLException {
    }

    protected void checkGroupCount(int aSize) throws SQLException {
    }

    public void testAdd() throws SQLException, UserMgtException {
        User user = this.createUser("user1", PASSWORD, this._group);
        InMemoryUserSetTest.assertTrue((boolean)this._users.add(user));
        this.checkUserExists(user.getName());
        this.checkUserCount(1);
        User user2 = this._users.find("user1");
        InMemoryUserSetTest.assertNotNull((Object)user2);
        InMemoryUserSetTest.assertEquals((String)user.getName(), (String)user2.getName());
        Set set = this._users.list();
        InMemoryUserSetTest.assertEquals((int)1, (int)set.size());
        InMemoryUserSetTest.assertTrue((boolean)set.contains(user));
    }

    public void testFindUnknownUser() throws SQLException, UserMgtException {
        User user1 = this.createUser("user1", PASSWORD, this._group);
        User user2 = this.createUser("user2", PASSWORD, this._group);
        this._users.add(user1);
        this._users.add(user2);
        this.checkUserExists(user1.getName());
        this.checkUserExists(user2.getName());
        InMemoryUserSetTest.assertNull((Object)this._users.find("user3"));
        this.checkUserNotExists("user3");
    }

    public void testAddDuplicateUser() throws SQLException, UserMgtException {
        User user1 = this.createUser("user1", PASSWORD, this._group);
        this._users.add(user1);
        InMemoryUserSetTest.assertEquals((int)1, (int)this._users.list().size());
        InMemoryUserSetTest.assertTrue((boolean)this._users.contains(user1));
        user1 = this.createUser("user1", PASSWORD, this._group);
        InMemoryUserSetTest.assertFalse((boolean)this._users.add(user1));
        InMemoryUserSetTest.assertEquals((int)1, (int)this._users.list().size());
        this.checkUserExists(user1.getName());
        this.checkUserCount(1);
    }

    public void testRemoveUser() throws SQLException, UserMgtException {
        User user1 = this.createUser("user1", PASSWORD, this._group);
        this._users.add(user1);
        InMemoryUserSetTest.assertTrue((boolean)this._users.contains(user1));
        this.checkUserCount(1);
        InMemoryUserSetTest.assertTrue((boolean)this._users.remove(user1));
        InMemoryUserSetTest.assertFalse((boolean)this._users.contains(user1));
        InMemoryUserSetTest.assertNull((Object)this._users.find(user1.getName()));
        InMemoryUserSetTest.assertEquals((int)0, (int)this._users.list().size());
        this.checkUserCount(0);
    }

    public void testRemoveNonExistingUser() throws SQLException, UserMgtException {
        User user1 = this.createUser("user1", PASSWORD, this._group);
        this._users.add(user1);
        this.checkUserCount(1);
        User nonExistingUser = this.createUser("user2", PASSWORD, this._group);
        nonExistingUser.setPrimaryKey((Serializable)new Long(1000L));
        nonExistingUser.setPersistedVersion(10);
        InMemoryUserSetTest.assertFalse((boolean)this._users.remove(nonExistingUser));
        InMemoryUserSetTest.assertTrue((boolean)this._users.contains(user1));
        InMemoryUserSetTest.assertEquals((int)1, (int)this._users.list().size());
        this.checkUserCount(1);
    }

    public void testList() throws SQLException, UserMgtException {
        User user1 = this.createUser("user1", PASSWORD, this._group);
        User user2 = this.createUser("user2", PASSWORD, this._group);
        User user3 = this.createUser("user3", PASSWORD, this._group);
        InMemoryUserSetTest.assertTrue((boolean)this._users.add(user1));
        InMemoryUserSetTest.assertTrue((boolean)this._users.add(user2));
        InMemoryUserSetTest.assertTrue((boolean)this._users.add(user3));
        this.checkUserExists(user1.getName());
        this.checkUserExists(user2.getName());
        this.checkUserExists(user3.getName());
        Set set = this._users.list();
        InMemoryUserSetTest.assertTrue((boolean)set.contains(user1));
        InMemoryUserSetTest.assertTrue((boolean)set.contains(user2));
        InMemoryUserSetTest.assertTrue((boolean)set.contains(user3));
        this.checkUserCount(3);
    }

    public void testListByGroup() throws SQLException, UserMgtException {
        Group group1 = new Group("group1");
        Group group2 = new Group("group2");
        Group group3 = new Group("group3");
        this._groups.add(group1);
        this._groups.add(group2);
        this._groups.add(group3);
        User user1 = this.createUser("user1", PASSWORD, group1);
        user1.addGroup(group2);
        user1.addGroup(group3);
        User user2 = this.createUser("user2", PASSWORD, group2);
        user2.addGroup(group3);
        User user3 = this.createUser("user3", PASSWORD, group3);
        this._users.add(user1);
        this._users.add(user2);
        this._users.add(user3);
        this.checkUserExists(user1.getName());
        this.checkUserExists(user2.getName());
        this.checkUserExists(user3.getName());
        this.checkGroupExists(group1.getName());
        this.checkGroupExists(group2.getName());
        this.checkGroupExists(group3.getName());
        this.checkUserCount(3);
        this.checkGroupCount(4);
        Set list = this._users.list(group1);
        InMemoryUserSetTest.assertTrue((boolean)list.contains(user1));
        InMemoryUserSetTest.assertEquals((int)1, (int)list.size());
        list = this._users.list(group2);
        InMemoryUserSetTest.assertTrue((boolean)list.contains(user1));
        InMemoryUserSetTest.assertTrue((boolean)list.contains(user2));
        InMemoryUserSetTest.assertEquals((int)2, (int)list.size());
        list = this._users.list(group3);
        InMemoryUserSetTest.assertTrue((boolean)list.contains(user1));
        InMemoryUserSetTest.assertTrue((boolean)list.contains(user2));
        InMemoryUserSetTest.assertTrue((boolean)list.contains(user3));
        InMemoryUserSetTest.assertEquals((int)3, (int)list.size());
    }
}

