/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.util.Set;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.wamblee.security.encryption.Md5HexMessageDigester;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.InMemoryGroupSet;
import org.wamblee.usermgt.InMemoryUserSet;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.RegexpNameValidator;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserAdministration;
import org.wamblee.usermgt.UserAdministrationImpl;
import org.wamblee.usermgt.UserMgtException;
import org.wamblee.usermgt.UserSet;
import org.wamblee.usermgt.UsermgtTestUtils;

public class UserAdministrationImplTest
extends TestCase {
    private static final Logger LOGGER = Logger.getLogger(UserAdministrationImplTest.class);
    private static final String USER1 = "piet";
    private static final String PASS1 = "passpiet";
    private static final String USER2 = "kees";
    private static final String PASS2 = "passkees";
    private static final String GROUP1 = "cyclists";
    private static final String GROUP2 = "runners";
    private UserAdministration _admin;

    protected void setUp() throws Exception {
        super.setUp();
        this._admin = this.createAdmin();
    }

    protected UserAdministration createAdmin() {
        InMemoryUserSet users = new InMemoryUserSet((NameValidator)new RegexpNameValidator(".{6}.*", UserMgtException.Reason.INVALID_PASSWORD, "Password must contain at least 6 characters"), (MessageDigester)new Md5HexMessageDigester());
        InMemoryGroupSet groups = new InMemoryGroupSet();
        return new UserAdministrationImpl((UserSet)users, (GroupSet)groups, (NameValidator)new RegexpNameValidator("[a-zA-Z]+[a-zA-Z0-9]*", UserMgtException.Reason.INVALID_USERNAME, "Invalid user"), (NameValidator)new RegexpNameValidator("[a-zA-Z]+[a-zA-Z0-9]*", UserMgtException.Reason.INVALID_GROUPNAME, "Invalid group"));
    }

    protected User createUser(String aName, String aPassword, Group aGroup) throws UserMgtException {
        return UsermgtTestUtils.createUser(aName, aPassword, aGroup);
    }

    public void testConstruct() {
        UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getUsers().size());
        UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getGroups().size());
        UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getUserCount());
        UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getGroupCount());
    }

    public void testCreateGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        UserAdministrationImplTest.assertNotNull((Object)group);
        UserAdministrationImplTest.assertEquals((String)GROUP1, (String)group.getName());
        Set groups = this._admin.getGroups();
        UserAdministrationImplTest.assertEquals((int)1, (int)groups.size());
        UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getGroupCount());
        UserAdministrationImplTest.assertTrue((boolean)groups.contains(group));
    }

    private void createInvalidGroup(String aUsername) {
        try {
            this._admin.createGroup(aUsername);
            UserAdministrationImplTest.fail();
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.INVALID_GROUPNAME, (Object)e.getReason());
            UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getGroupCount());
        }
    }

    public void testCreateInvalidGroupName() throws UserMgtException {
        this.createInvalidGroup("");
        this.createInvalidGroup("0abc");
        this.createInvalidGroup("a b");
        this.createInvalidGroup(" aa");
        this.createInvalidGroup("aa ");
    }

    public void testCreateDuplicateGroup() throws UserMgtException {
        this._admin.createGroup(GROUP1);
        try {
            this._admin.createGroup(GROUP1);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.DUPLICATE_GROUP, (Object)e.getReason());
            UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getGroupCount());
            return;
        }
        UserAdministrationImplTest.fail();
    }

    public void testCreateUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        UserAdministrationImplTest.assertNotNull((Object)user);
        UserAdministrationImplTest.assertEquals((String)USER1, (String)user.getName());
        user.checkPassword(PASS1);
        Set users = this._admin.getUsers();
        UserAdministrationImplTest.assertEquals((int)1, (int)users.size());
        UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getUserCount());
        UserAdministrationImplTest.assertTrue((boolean)users.contains(user));
    }

    private void createInvalidUser(String aUsername, Group aGroup) {
        try {
            this._admin.createUser(aUsername, "pass", aGroup);
            UserAdministrationImplTest.fail();
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.INVALID_USERNAME, (Object)e.getReason());
            UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getUserCount());
        }
    }

    public void testCreateInvalidUserName() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        this.createInvalidUser("", group);
        this.createInvalidUser("0abc", group);
        this.createInvalidUser("a b", group);
        this.createInvalidUser(" aa", group);
        this.createInvalidUser("aa ", group);
    }

    public void testCreateDuplicateUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        this._admin.createUser(USER1, PASS1, group);
        try {
            this._admin.createUser(USER1, PASS2, group);
            UserAdministrationImplTest.fail();
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.DUPLICATE_USER, (Object)e.getReason());
            UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getUserCount());
        }
    }

    public void testGetUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        User user2 = this._admin.getUser(USER1);
        UserAdministrationImplTest.assertTrue((boolean)user.equals((Object)user2));
        UserAdministrationImplTest.assertNull((Object)this._admin.getUser(USER2));
    }

    public void testGetGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        Group group2 = this._admin.getGroup(GROUP1);
        UserAdministrationImplTest.assertTrue((boolean)group.equals((Object)group2));
        UserAdministrationImplTest.assertNull((Object)this._admin.getGroup(GROUP2));
    }

    public void testAddUserToGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        Group group2 = this._admin.createGroup(GROUP2);
        UserAdministrationImplTest.assertTrue((boolean)user.isInGroup(group));
        UserAdministrationImplTest.assertFalse((boolean)user.isInGroup(group2));
        this._admin.addUserToGroup(user, group2);
        UserAdministrationImplTest.assertTrue((boolean)user.isInGroup(group));
        UserAdministrationImplTest.assertTrue((boolean)user.isInGroup(group2));
        Set users = this._admin.getUsers(group2);
        UserAdministrationImplTest.assertNotNull((Object)users);
        UserAdministrationImplTest.assertEquals((int)1, (int)users.size());
        UserAdministrationImplTest.assertTrue((boolean)users.contains(user));
        try {
            this._admin.addUserToGroup(user, group);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.USER_ALREADY_IN_GROUP, (Object)e.getReason());
            return;
        }
        UserAdministrationImplTest.fail();
    }

    public void testAddUserToGroupUnknownUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this.createUser(USER1, PASS1, group);
        try {
            this._admin.addUserToGroup(user, group);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.UNKNOWN_USER, (Object)e.getReason());
            return;
        }
        UserAdministrationImplTest.fail();
    }

    public void testAddUserToGroupUnknownGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        Group group2 = new Group(GROUP2);
        try {
            this._admin.addUserToGroup(user, group2);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.UNKNOWN_GROUP, (Object)e.getReason());
            return;
        }
        UserAdministrationImplTest.fail();
    }

    public void testRemoveUserFromGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        Group group2 = this._admin.createGroup(GROUP2);
        this._admin.addUserToGroup(user, group2);
        Set groups = user.getGroups();
        UserAdministrationImplTest.assertEquals((int)2, (int)groups.size());
        UserAdministrationImplTest.assertTrue((boolean)groups.contains(group));
        UserAdministrationImplTest.assertTrue((boolean)groups.contains(group2));
        this._admin.removeUserFromGroup(user, group);
        groups = user.getGroups();
        UserAdministrationImplTest.assertEquals((int)1, (int)groups.size());
        UserAdministrationImplTest.assertTrue((boolean)groups.contains(group2));
        UserAdministrationImplTest.assertFalse((boolean)groups.contains(group));
    }

    public void testRemoveUserFromGroupUnknownUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this.createUser(USER1, GROUP1, group);
        try {
            this._admin.removeUserFromGroup(user, group);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.UNKNOWN_USER, (Object)e.getReason());
        }
    }

    public void testRemoveUserFromGroupUnknownGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        Group group2 = new Group(GROUP2);
        try {
            this._admin.removeUserFromGroup(user, group2);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.UNKNOWN_GROUP, (Object)e.getReason());
        }
    }

    public void testRemoveUserFromGroupOnlyGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        try {
            this._admin.removeUserFromGroup(user, group);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.USER_MUST_BE_IN_A_GROUP, (Object)e.getReason());
        }
    }

    public void testGetUsersAndGroups() throws UserMgtException {
        Group group1 = this._admin.createGroup(GROUP1);
        Group group2 = this._admin.createGroup(GROUP2);
        User user1 = this._admin.createUser(USER1, PASS1, group1);
        this._admin.addUserToGroup(user1, group2);
        User user2 = this._admin.createUser(USER2, PASS2, group2);
        Set users = this._admin.getUsers();
        UserAdministrationImplTest.assertEquals((int)2, (int)users.size());
        UserAdministrationImplTest.assertTrue((boolean)users.contains(user1));
        UserAdministrationImplTest.assertTrue((boolean)users.contains(user2));
        Set groups = this._admin.getGroups();
        UserAdministrationImplTest.assertEquals((int)2, (int)groups.size());
        UserAdministrationImplTest.assertTrue((boolean)groups.contains(group1));
        UserAdministrationImplTest.assertTrue((boolean)groups.contains(group2));
        UserAdministrationImplTest.assertTrue((boolean)user1.isInGroup(group1));
        UserAdministrationImplTest.assertTrue((boolean)user1.isInGroup(group2));
        UserAdministrationImplTest.assertFalse((boolean)user2.isInGroup(group1));
        UserAdministrationImplTest.assertTrue((boolean)user2.isInGroup(group2));
        Set groups1 = user1.getGroups();
        UserAdministrationImplTest.assertEquals((int)2, (int)groups1.size());
        Set groups2 = user2.getGroups();
        UserAdministrationImplTest.assertEquals((int)1, (int)groups2.size());
    }

    public void testRenameUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user1 = this._admin.createUser(USER1, PASS1, group);
        this._admin.renameUser(user1, USER2);
        UserAdministrationImplTest.assertEquals((String)USER2, (String)user1.getName());
        UserAdministrationImplTest.assertEquals((Object)user1, (Object)this._admin.getUser(USER2));
        this._admin.createUser(USER1, PASS1, group);
        try {
            this._admin.renameUser(user1, USER1);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.DUPLICATE_USER, (Object)e.getReason());
            try {
                this._admin.renameUser(user1, user1.getName());
            }
            catch (UserMgtException e2) {
                UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.TRIVIAL_RENAME, (Object)e2.getReason());
                return;
            }
            UserAdministrationImplTest.fail();
        }
        UserAdministrationImplTest.fail();
    }

    public void testRenameUserInvalidUsername() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user1 = this._admin.createUser(USER1, PASS1, group);
        try {
            this._admin.renameUser(user1, USER2);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)e.getReason(), (Object)UserMgtException.Reason.INVALID_USERNAME);
        }
    }

    public void testRenameGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        this._admin.renameGroup(group, GROUP2);
        UserAdministrationImplTest.assertEquals((String)GROUP2, (String)group.getName());
        UserAdministrationImplTest.assertEquals((Object)group, (Object)this._admin.getGroup(GROUP2));
        this._admin.createGroup(GROUP1);
        try {
            this._admin.renameGroup(group, GROUP1);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.DUPLICATE_GROUP, (Object)e.getReason());
            try {
                this._admin.renameGroup(group, group.getName());
            }
            catch (UserMgtException e2) {
                UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.TRIVIAL_RENAME, (Object)e2.getReason());
                return;
            }
            UserAdministrationImplTest.fail();
            return;
        }
        UserAdministrationImplTest.fail();
    }

    public void testRenameGroupInvalidGroupname() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        try {
            this._admin.renameGroup(group, "a b");
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)e.getReason(), (Object)UserMgtException.Reason.INVALID_GROUPNAME);
        }
    }

    public void testRemoveUser() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getUserCount());
        this._admin.removeUser(user);
        UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getUserCount());
        this._admin.createUser(USER1, PASS1, group);
        UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getUserCount());
        User user2 = this.createUser(USER2, PASS2, group);
        try {
            this._admin.removeUser(user2);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.UNKNOWN_USER, (Object)e.getReason());
        }
    }

    public void testRemoveGroup() throws UserMgtException {
        Group group1 = this._admin.createGroup(GROUP1);
        UserAdministrationImplTest.assertEquals((int)1, (int)this._admin.getGroupCount());
        this._admin.removeGroup(group1);
        UserAdministrationImplTest.assertEquals((int)0, (int)this._admin.getGroupCount());
        group1 = this._admin.createGroup(GROUP1);
        this._admin.createUser(USER1, PASS1, group1);
        try {
            this._admin.removeGroup(group1);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.GROUP_STILL_OCCUPIED, (Object)e.getReason());
            return;
        }
        UserAdministrationImplTest.fail();
    }

    public void testRemoveGroupUnknownGroup() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        Group group2 = new Group(GROUP2);
        try {
            this._admin.removeGroup(group2);
        }
        catch (UserMgtException e) {
            UserAdministrationImplTest.assertEquals((Object)UserMgtException.Reason.UNKNOWN_GROUP, (Object)e.getReason());
        }
    }

    public void testChangePassword() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        User user = this._admin.createUser(USER1, PASS1, group);
        user.changePassword(PASS1, PASS2);
        User user2 = this._admin.getUser(USER1);
        try {
            user2.checkPassword(PASS2);
            UserAdministrationImplTest.fail();
        }
        catch (UserMgtException e) {
            // empty catch block
        }
        this._admin.userModified(user);
        user2 = this._admin.getUser(USER1);
        user2.checkPassword(PASS2);
    }

    public void testPerformanceFindUserByName() throws UserMgtException {
        Group group = this._admin.createGroup(GROUP1);
        this._admin.createUser(USER1, PASS1, group);
        int n = 1000;
        long time = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            this._admin.getUser(USER1);
        }
        LOGGER.info((Object)("Looked up a user " + n + " times in " + (double)(System.currentTimeMillis() - time) / 1000.0));
    }
}

