/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import org.wamblee.security.encryption.Md5HexMessageDigester;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.RegexpNameValidator;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserMgtException;

public class UsermgtTestUtils {
    private static final String DUMMY_GROUP = "dummygroup";
    private static final String DUMMY_PASSWD = "dummypasswd";

    public static Group createGroup(String aName) {
        return new Group(aName);
    }

    public static User createUser(String aUsername) throws UserMgtException {
        return UsermgtTestUtils.createUser(aUsername, DUMMY_GROUP);
    }

    public static User createUser(String aUsername, String aGroup) throws UserMgtException {
        return UsermgtTestUtils.createUser(aUsername, UsermgtTestUtils.createGroup(aGroup));
    }

    public static User createUser(String aUsername, Group aGroup) throws UserMgtException {
        return UsermgtTestUtils.createUser(aUsername, DUMMY_PASSWD, aGroup);
    }

    public static User createUser(String aName, String aPassword, Group aGroup) throws UserMgtException {
        return new User(aName, aPassword, aGroup, (NameValidator)new RegexpNameValidator(".{6}.*", UserMgtException.Reason.INVALID_PASSWORD, "Password must be at least 6 chars"), (MessageDigester)new Md5HexMessageDigester());
    }

    public static void addUserToGroup(User aUser, Group aGroup) throws UserMgtException {
        aUser.addGroup(aGroup);
    }

    public static void removeUserFromGroup(User aUser, Group aGroup) throws UserMgtException {
        aUser.removeGroup(aGroup);
    }
}

