/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt.hibernate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.wamblee.system.adapters.DefaultContainer;
import org.wamblee.system.adapters.ObjectConfiguration;
import org.wamblee.system.core.Scope;
import org.wamblee.system.spring.component.DatabaseTesterComponent;
import org.wamblee.test.spring.TestTransactionCallback;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.InMemoryGroupSetTest;
import org.wamblee.usermgt.hibernate.UserMgtRepositoryTestContainer;

public class HibernateGroupSetTest
extends InMemoryGroupSetTest {
    private static final String GROUP_TABLE = "GROUPS";
    private static final String GROUP_QUERY = "select * from GROUPS where name = ?";
    private DefaultContainer _container;
    private Scope _scope;
    private DatabaseTesterComponent _databaseTester;
    private GroupSet _groupSet;

    @Override
    protected void setUp() throws Exception {
        this._container = new UserMgtRepositoryTestContainer("top");
        ObjectConfiguration config = new ObjectConfiguration(HibernateGroupSetTest.class);
        config.getSetterConfig().clear().add("setGroupSet").add("setDatabaseTester");
        this._container.addComponent("testcase", (Object)this, config);
        this._scope = this._container.start();
        this._databaseTester.cleanDatabase();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this._container.stop((Object)this._scope);
        super.tearDown();
    }

    public void setDatabaseTester(DatabaseTesterComponent aDatabaseTester) {
        this._databaseTester = aDatabaseTester;
    }

    public void setGroupSet(GroupSet aGroupSet) {
        this._groupSet = aGroupSet;
    }

    @Override
    protected void checkGroupCount(int aSize) throws SQLException {
        this._databaseTester.flush();
        super.checkGroupCount(aSize);
        HibernateGroupSetTest.assertEquals((int)aSize, (int)this._databaseTester.getTableSize(GROUP_TABLE));
    }

    @Override
    protected void checkGroupExists(final String aGroup) throws SQLException {
        this._databaseTester.flush();
        Map result = this._databaseTester.executeTransaction(new TestTransactionCallback(){

            public Map execute() throws Exception {
                ResultSet result = HibernateGroupSetTest.this._databaseTester.executeQuery(HibernateGroupSetTest.GROUP_QUERY, (Object)aGroup);
                HashMap<String, Integer> res = new HashMap<String, Integer>();
                res.put("result", HibernateGroupSetTest.this._databaseTester.countResultSet(result));
                return res;
            }
        });
        int count = (Integer)result.get("result");
        HibernateGroupSetTest.assertEquals((int)1, (int)count);
    }

    @Override
    protected void checkGroupNotExists(String aGroup) throws SQLException {
        this._databaseTester.flush();
        ResultSet result = this._databaseTester.executeQuery(GROUP_QUERY, (Object)aGroup);
        HibernateGroupSetTest.assertEquals((int)0, (int)this._databaseTester.countResultSet(result));
    }

    @Override
    protected GroupSet createGroupSet() {
        return this._groupSet;
    }
}

