/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wamblee.cache.EhCache;
import org.wamblee.system.adapters.ClassConfiguration;
import org.wamblee.system.adapters.DefaultContainer;
import org.wamblee.system.adapters.ObjectConfiguration;
import org.wamblee.system.components.DatabaseComponentFactory;
import org.wamblee.system.container.Container;
import org.wamblee.system.core.Component;
import org.wamblee.system.core.Scope;
import org.wamblee.system.spring.component.DatabaseTesterComponent;
import org.wamblee.system.spring.component.DatasourceComponent;
import org.wamblee.test.spring.TestTransactionCallbackWithoutResult;
import org.wamblee.usermgt.UserAdministration;
import org.wamblee.usermgt.UserAdministrationImplTest;
import org.wamblee.usermgt.hibernate.UserAdministrationComponent;

public class HibernateUserAdministrationTest
extends UserAdministrationImplTest {
    private static final Log LOG = LogFactory.getLog(HibernateUserAdministrationTest.class);
    private DefaultContainer _container;
    private Scope _scope;
    private DatabaseTesterComponent _databaseTester;
    private EhCache<Serializable, Serializable> _userCache;
    private UserAdministration _userAdmin;

    @Override
    protected void setUp() throws Exception {
        this._container = new DefaultContainer("top");
        DatabaseComponentFactory.addDatabaseConfig((Container)this._container);
        this._container.addComponent((Component)new DatasourceComponent("datasource"));
        this._container.addComponent((Component)new UserAdministrationComponent("admin", true));
        ClassConfiguration dbtesterConfig = new ClassConfiguration(DatabaseTesterComponent.class);
        dbtesterConfig.getObjectConfig().getSetterConfig().initAllSetters();
        this._container.addComponent("databaseTester", dbtesterConfig);
        ObjectConfiguration config = new ObjectConfiguration(HibernateUserAdministrationTest.class);
        config.getSetterConfig().clear().add("setUserCache").add("setDatabaseTester").add("setUserAdmin");
        this._container.addComponent("testcase", (Object)this, config);
        this._scope = this._container.start();
        this._databaseTester.cleanDatabase();
        super.setUp();
        this.clearUserCache();
    }

    public void setUserCache(EhCache<Serializable, Serializable> aUserCache) {
        this._userCache = aUserCache;
    }

    public void setDatabaseTester(DatabaseTesterComponent aDatabaseTester) {
        this._databaseTester = aDatabaseTester;
    }

    public void setUserAdmin(UserAdministration aUserAdmin) {
        this._userAdmin = aUserAdmin;
    }

    protected void tearDown() throws Exception {
        this._container.stop((Object)this._scope);
        super.tearDown();
    }

    @Override
    protected UserAdministration createAdmin() {
        return this._userAdmin;
    }

    public void testAllTestsInASeparateTransaction() throws SQLException {
        Method[] methods;
        for (final Method method : methods = UserAdministrationImplTest.class.getMethods()) {
            if (!method.getName().startsWith("test")) continue;
            this._databaseTester.cleanDatabase();
            this.clearUserCache();
            this._databaseTester.executeTransaction(new TestTransactionCallbackWithoutResult(){

                public void execute() throws Exception {
                    LOG.info((Object)("Running test " + method.getName()));
                    try {
                        method.invoke((Object)HibernateUserAdministrationTest.this, new Object[0]);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Test " + method.getName() + " failed"));
                        throw new RuntimeException(t.getMessage(), t);
                    }
                    finally {
                        LOG.info((Object)("Test " + method.getName() + " finished"));
                    }
                }
            });
        }
    }

    private void clearUserCache() {
        this._userCache.clear();
    }
}

