/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt.hibernate;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.wamblee.cache.EhCache;
import org.wamblee.system.adapters.DefaultContainer;
import org.wamblee.system.adapters.ObjectConfiguration;
import org.wamblee.system.core.Scope;
import org.wamblee.system.spring.component.DatabaseTesterComponent;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.InMemoryUserSetTest;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserMgtException;
import org.wamblee.usermgt.UserSet;
import org.wamblee.usermgt.hibernate.UserMgtRepositoryTestContainer;

public class HibernateUserSetTest
extends InMemoryUserSetTest {
    private static final String USER_TABLE = "USERS";
    private static final String GROUP_TABLE = "GROUPS";
    private static final String USER_QUERY = "select * from USERS where name = ?";
    private static final String GROUP_QUERY = "select * from GROUPS where name = ?";
    private DefaultContainer _container;
    private Scope _scope;
    private UserSet _userset;
    private GroupSet _groupset;
    private EhCache<Serializable, Serializable> _userCache;
    private DatabaseTesterComponent _databaseTester;

    @Override
    protected void setUp() throws Exception {
        this._container = new UserMgtRepositoryTestContainer("top");
        ObjectConfiguration config = new ObjectConfiguration(HibernateUserSetTest.class);
        config.getSetterConfig().clear().add("setUserset").add("setGroupset").add("setDatabaseTester").add("setUserCache");
        this._container.addComponent("testcase", (Object)this, config);
        this._scope = this._container.start();
        this.clearUserCache();
        this._databaseTester.cleanDatabase();
        super.setUp();
    }

    public void setUserset(UserSet aUserset) {
        this._userset = aUserset;
    }

    public void setGroupset(GroupSet aGroupset) {
        this._groupset = aGroupset;
    }

    public void setUserCache(EhCache<Serializable, Serializable> aUserCache) {
        this._userCache = aUserCache;
    }

    public void setDatabaseTester(DatabaseTesterComponent aDatabaseTester) {
        this._databaseTester = aDatabaseTester;
    }

    protected void tearDown() throws Exception {
        this._container.stop((Object)this._scope);
        super.tearDown();
    }

    private void clearUserCache() {
        this._userCache.clear();
    }

    @Override
    protected void checkUserCount(int aSize) throws SQLException {
        this._databaseTester.flush();
        super.checkUserCount(aSize);
        HibernateUserSetTest.assertEquals((int)aSize, (int)this._databaseTester.getTableSize(USER_TABLE));
    }

    @Override
    protected void checkUserExists(String aUser) throws SQLException {
        this._databaseTester.flush();
        ResultSet result = this._databaseTester.executeQuery(USER_QUERY, (Object)aUser);
        HibernateUserSetTest.assertEquals((int)1, (int)this._databaseTester.countResultSet(result));
    }

    @Override
    protected void checkUserNotExists(String aUser) throws SQLException {
        this._databaseTester.flush();
        ResultSet result = this._databaseTester.executeQuery(USER_QUERY, (Object)aUser);
        HibernateUserSetTest.assertEquals((int)0, (int)this._databaseTester.countResultSet(result));
    }

    @Override
    protected void checkGroupCount(int aSize) throws SQLException {
        this._databaseTester.flush();
        HibernateUserSetTest.assertEquals((int)aSize, (int)this._databaseTester.getTableSize(GROUP_TABLE));
    }

    @Override
    protected void checkGroupExists(String aGroup) throws SQLException {
        this._databaseTester.flush();
        ResultSet result = this._databaseTester.executeQuery(GROUP_QUERY, (Object)aGroup);
        HibernateUserSetTest.assertEquals((int)1, (int)this._databaseTester.countResultSet(result));
    }

    @Override
    protected void checkGroupNotExists(String aGroup) throws SQLException {
        this._databaseTester.flush();
        ResultSet result = this._databaseTester.executeQuery(GROUP_QUERY, (Object)aGroup);
        HibernateUserSetTest.assertEquals((int)0, (int)this._databaseTester.countResultSet(result));
    }

    @Override
    protected UserSet createUserSet() {
        return this._userset;
    }

    @Override
    protected GroupSet createGroupSet() {
        return this._groupset;
    }

    public void testVerifyAddRemove() throws SQLException, UserMgtException {
        this._databaseTester.cleanDatabase();
        GroupSet groups = this.getGroups();
        HibernateUserSetTest.assertEquals((int)0, (int)groups.size());
        Group group1 = this.createGroup("group1");
        Group group2 = this.createGroup("group2");
        groups.add(group1);
        groups.add(group2);
        this.checkGroupExists("group1");
        this.checkGroupExists("group2");
        User user = this.createUser("user", "abc123", group1);
        this.getUsers().add(user);
        this.checkUserExists("user");
        this.addUserToGroup(user, group2);
        this.getUsers().userModified(user);
        this.clearUserCache();
        User user2 = this.getUsers().find("user");
        Set userGroups = user2.getGroups();
        HibernateUserSetTest.assertTrue((boolean)user2.isInGroup("group1"));
        HibernateUserSetTest.assertTrue((boolean)user2.isInGroup("group2"));
        HibernateUserSetTest.assertEquals((int)2, (int)userGroups.size());
        this.removeUserFromGroup(user, group1);
        this.getUsers().userModified(user);
        this.clearUserCache();
        user2 = this.getUsers().find("user");
        userGroups = user2.getGroups();
        HibernateUserSetTest.assertFalse((boolean)user2.isInGroup("group1"));
        HibernateUserSetTest.assertTrue((boolean)user2.isInGroup("group2"));
        HibernateUserSetTest.assertEquals((int)1, (int)userGroups.size());
    }
}

