/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import java.util.ArrayList;
import java.util.List;
import org.wamblee.persistence.AbstractPersistent;
import org.wamblee.security.authorization.AuthorizationException;
import org.wamblee.security.authorization.AuthorizationRule;
import org.wamblee.security.authorization.AuthorizationService;
import org.wamblee.security.authorization.Operation;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserAccessor;

public class DefaultAuthorizationService
extends AbstractPersistent
implements AuthorizationService {
    private List<AuthorizationRule> _rules = new ArrayList<AuthorizationRule>();
    private UserAccessor _userAccessor;
    private String _name;

    public DefaultAuthorizationService(UserAccessor aAccessor, String aName) {
        this._userAccessor = aAccessor;
        this._name = aName;
    }

    public DefaultAuthorizationService() {
        this._userAccessor = null;
        this._name = null;
    }

    public void setUserAccessor(UserAccessor aUserAccessor) {
        this._userAccessor = aUserAccessor;
    }

    @Override
    public boolean isAllowed(Object aResource, Operation aOperation) {
        User user = this._userAccessor.getCurrentUser();
        for (AuthorizationRule rule : this._rules) {
            switch (rule.isAllowed(aResource, aOperation, user)) {
                case DENIED: {
                    return false;
                }
                case GRANTED: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public <T> T check(T aResource, Operation aOperation) {
        if (!this.isAllowed(aResource, aOperation)) {
            throw new AuthorizationException(aResource, aOperation);
        }
        return aResource;
    }

    protected String getName() {
        return this._name;
    }

    public void setName(String aName) {
        this._name = aName;
    }

    @Override
    public AuthorizationRule[] getRules() {
        return this._rules.toArray(new AuthorizationRule[0]);
    }

    @Override
    public void appendRule(AuthorizationRule aRule) {
        this._rules.add(aRule);
    }

    @Override
    public void insertRuleAfter(int aIndex, AuthorizationRule aRule) {
        this._rules.add(aIndex, aRule);
    }

    @Override
    public void removeRule(int aIndex) {
        this._rules.remove(aIndex);
    }

    protected List<AuthorizationRule> getMappedRules() {
        return this._rules;
    }

    protected void setMappedRules(List<AuthorizationRule> aRules) {
        this._rules = aRules;
    }
}

