/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.wamblee.security.authorization.Operation;
import org.wamblee.security.authorization.OperationRegistry;

public class DefaultOperationRegistry
implements OperationRegistry {
    private Map<String, Operation> _operations = new TreeMap<String, Operation>();

    public DefaultOperationRegistry(Operation[] aOperations) {
        for (Operation operation : aOperations) {
            this._operations.put(operation.getName(), operation);
        }
    }

    @Override
    public Operation[] getOperations(Class aResourceClass) {
        return this._operations.values().toArray(new Operation[0]);
    }

    @Override
    public String encode(Operation[] aOperations) {
        StringBuffer buffer = new StringBuffer();
        for (Operation operation : aOperations) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(operation.getName());
        }
        return buffer.toString();
    }

    @Override
    public Operation[] decode(Class aResourceClass, String aOperationsString) {
        return this.decode(aOperationsString);
    }

    @Override
    public Operation[] decode(String aOperationsString) {
        if (aOperationsString.length() == 0) {
            return new Operation[0];
        }
        String[] names = aOperationsString.split(",");
        ArrayList<Operation> result = new ArrayList<Operation>();
        for (String name : names) {
            Operation operation = this._operations.get(name);
            if (operation == null) {
                throw new IllegalArgumentException("Unknown operation '" + name + "'");
            }
            result.add(operation);
        }
        return result.toArray(new Operation[0]);
    }
}

