/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization;

import org.apache.log4j.Logger;
import org.wamblee.persistence.AbstractPersistent;
import org.wamblee.security.authorization.AuthorizationResult;
import org.wamblee.security.authorization.AuthorizationRule;
import org.wamblee.security.authorization.Operation;
import org.wamblee.security.authorization.OperationCondition;
import org.wamblee.security.authorization.PathCondition;
import org.wamblee.security.authorization.UserCondition;
import org.wamblee.usermgt.User;

public abstract class UrlAuthorizationRule
extends AbstractPersistent
implements AuthorizationRule {
    private static final Logger LOGGER = Logger.getLogger(UrlAuthorizationRule.class);
    private AuthorizationResult _result;
    private UserCondition _userCondition;
    private PathCondition _pathCondition;
    private Class _resourceClass;
    private OperationCondition _operationCondition;

    protected UrlAuthorizationRule(AuthorizationResult aResult, UserCondition aUserCondition, PathCondition aPathCondition, Class aResourceClass, OperationCondition aOperationCondition) {
        if (!aResult.equals((Object)AuthorizationResult.GRANTED) && !aResult.equals((Object)AuthorizationResult.DENIED)) {
            throw new IllegalArgumentException("Only GRANTED or DENIED may be used: " + (Object)((Object)aResult));
        }
        this._result = aResult;
        this._userCondition = aUserCondition;
        this._pathCondition = aPathCondition;
        this._resourceClass = aResourceClass;
        this._operationCondition = aOperationCondition;
    }

    protected UrlAuthorizationRule(Class aResourceClass) {
        this._result = null;
        this._userCondition = null;
        this._pathCondition = null;
        this._resourceClass = aResourceClass;
        this._operationCondition = null;
    }

    protected UrlAuthorizationRule() {
        this._result = null;
        this._userCondition = null;
        this._pathCondition = null;
        this._resourceClass = null;
        this._operationCondition = null;
    }

    @Override
    public Class[] getSupportedTypes() {
        return new Class[]{this._resourceClass};
    }

    @Override
    public AuthorizationResult isAllowed(Object aResource, Operation anOperation, User aUser) {
        if (!this._resourceClass.isInstance(aResource)) {
            return AuthorizationResult.UNSUPPORTED_RESOURCE;
        }
        String path = this.getResourcePath(aResource);
        return this.isAllowed(path, anOperation, aUser);
    }

    protected AuthorizationResult isAllowed(String aPath, Operation aOperation, User aUser) {
        if (!this._pathCondition.matches(aPath)) {
            return AuthorizationResult.UNDECIDED;
        }
        if (!this._operationCondition.matches(aOperation)) {
            return AuthorizationResult.UNDECIDED;
        }
        if (!this._userCondition.matches(aUser)) {
            return AuthorizationResult.UNDECIDED;
        }
        return this._result;
    }

    protected abstract String getResourcePath(Object var1);

    public String toString() {
        return "UrlAUthorizationRule(result = " + (Object)((Object)this._result) + ", pathCondition = " + this._pathCondition + ", userCondition = " + this._userCondition + ", resourceClass = " + this._resourceClass + ")";
    }

    protected String getAuthorizationResultString() {
        if (this._result == null) {
            return null;
        }
        return this._result.toString();
    }

    protected void setAuthorizationResultString(String aResult) {
        this._result = AuthorizationResult.valueOf(aResult);
    }

    protected String getResourceClassName() {
        if (this._resourceClass == null) {
            return "";
        }
        return this._resourceClass.getName();
    }

    protected void setResourceClassName(String aResourceClass) {
        try {
            this._resourceClass = Class.forName(aResourceClass);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("Cannot find resource class '" + aResourceClass + "'"), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public OperationCondition getOperationCondition() {
        return this._operationCondition;
    }

    protected void setOperationCondition(OperationCondition aOperationCondition) {
        this._operationCondition = aOperationCondition;
    }

    public PathCondition getPathCondition() {
        return this._pathCondition;
    }

    protected void setPathCondition(PathCondition aPathCondition) {
        this._pathCondition = aPathCondition;
    }

    public UserCondition getUserCondition() {
        return this._userCondition;
    }

    protected void setUserCondition(UserCondition aUserCondition) {
        this._userCondition = aUserCondition;
    }
}

