/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.security.authorization.hibernate;

import java.util.List;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.wamblee.persistence.AbstractPersistent;
import org.wamblee.persistence.Persistent;
import org.wamblee.persistence.hibernate.HibernateSupport;
import org.wamblee.security.authorization.AuthorizationRule;
import org.wamblee.security.authorization.AuthorizationService;
import org.wamblee.security.authorization.DefaultAuthorizationService;
import org.wamblee.security.authorization.Operation;
import org.wamblee.usermgt.UserAccessor;

public class PersistentAuthorizationService
extends AbstractPersistent
implements AuthorizationService {
    private static final String FIND_QUERY = "findAuthorizationServiceByName";
    private static final String NAME_PARAM = "name";
    private DefaultAuthorizationService _service;
    private HibernateTemplate _template;
    private UserAccessor _userAccessor;
    private String _name;
    private final long _refreshInterval;
    private long _lastRefreshTime;

    public PersistentAuthorizationService(String aName, HibernateTemplate aTemplate, UserAccessor aAccessor, long aRefreshInterval) {
        this._template = aTemplate;
        this._refreshInterval = aRefreshInterval;
        this._lastRefreshTime = System.currentTimeMillis();
        this._userAccessor = aAccessor;
        this._name = aName;
    }

    private void initialize() {
        if (this._service == null) {
            List result = this._template.findByNamedQueryAndNamedParam(FIND_QUERY, NAME_PARAM, (Object)this._name);
            if (result.size() > 1) {
                throw new IllegalArgumentException("Returned more than one service for name '" + this._name + "' (" + result.size() + ")");
            }
            if (result.size() == 0) {
                this._service = new DefaultAuthorizationService(this._userAccessor, this._name);
                this._template.persist((Object)this._service);
            } else {
                this._service = (DefaultAuthorizationService)result.get(0);
                this._service.setUserAccessor(this._userAccessor);
            }
        }
    }

    @Override
    public boolean isAllowed(Object aResource, Operation aOperation) {
        this.initialize();
        this.refresh();
        return this._service.isAllowed(aResource, aOperation);
    }

    @Override
    public <T> T check(T aResource, Operation aOperation) {
        this.initialize();
        this.refresh();
        return this._service.check(aResource, aOperation);
    }

    @Override
    public AuthorizationRule[] getRules() {
        this.initialize();
        this.refresh();
        return this._service.getRules();
    }

    @Override
    public void appendRule(AuthorizationRule aRule) {
        this.initialize();
        this.refresh();
        this._service.appendRule(aRule);
        this.save();
    }

    @Override
    public void removeRule(int aIndex) {
        this.initialize();
        this.refresh();
        this._service.removeRule(aIndex);
        this.save();
    }

    @Override
    public void insertRuleAfter(int aIndex, AuthorizationRule aRule) {
        this.initialize();
        this.refresh();
        this._service.insertRuleAfter(aIndex, aRule);
        this.save();
    }

    private synchronized void refresh() {
        long time = System.currentTimeMillis();
        if (time - this._lastRefreshTime > this._refreshInterval) {
            this._template.refresh((Object)this._service);
            this._lastRefreshTime = time;
        }
    }

    private void save() {
        HibernateSupport.merge((HibernateTemplate)this._template, (Persistent)this._service);
    }
}

