/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserMgtException;
import org.wamblee.usermgt.UserSet;

public abstract class AbstractUserSet
implements UserSet {
    private NameValidator _passwordValidator;
    private MessageDigester _passwordEncoder;

    protected AbstractUserSet(NameValidator aPasswordValidator, MessageDigester aPasswordEncoder) {
        this._passwordValidator = aPasswordValidator;
        this._passwordEncoder = aPasswordEncoder;
    }

    protected void setPasswordInfo(User aUser) {
        aUser.setPasswordValidator(this._passwordValidator);
        aUser.setPasswordEncoder(this._passwordEncoder);
    }

    @Override
    public User createUser(String aUsername, String aPassword, Group aGroup) throws UserMgtException {
        User user = new User(aUsername, aPassword, aGroup, this._passwordValidator, this._passwordEncoder);
        if (this.contains(user)) {
            throw new UserMgtException(UserMgtException.Reason.DUPLICATE_USER, user);
        }
        this.add(user);
        return user;
    }
}

