/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.util.Set;
import java.util.TreeSet;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.AbstractUserSet;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.User;

public class InMemoryUserSet
extends AbstractUserSet {
    private Set<User> _users = new TreeSet<User>();

    public InMemoryUserSet(NameValidator aPasswordValidator, MessageDigester aPasswordEncoder) {
        super(aPasswordValidator, aPasswordEncoder);
    }

    @Override
    public void userModified(User aUser) {
        this._users.remove(aUser);
        this.setPasswordInfo(aUser);
        this._users.add(aUser);
    }

    @Override
    public User find(String aName) {
        for (User user : this._users) {
            if (!user.getName().equals(aName)) continue;
            return new User(user);
        }
        return null;
    }

    @Override
    public boolean add(User aUser) {
        this.setPasswordInfo(aUser);
        return this._users.add(aUser);
    }

    @Override
    public boolean contains(User aUser) {
        return this._users.contains(aUser);
    }

    @Override
    public boolean remove(User aUser) {
        return this._users.remove(aUser);
    }

    @Override
    public Set<User> list() {
        TreeSet<User> list = new TreeSet<User>();
        for (User user : this._users) {
            list.add(new User(user));
        }
        return list;
    }

    @Override
    public Set<User> list(Group aGroup) {
        TreeSet<User> result = new TreeSet<User>();
        for (User user : this._users) {
            if (!user.getGroups().contains(aGroup)) continue;
            result.add(new User(user));
        }
        return result;
    }

    @Override
    public int size() {
        return this._users.size();
    }
}

