/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserAccessor;
import org.wamblee.usermgt.UserAdministration;

public class JaasUserAccessor
implements UserAccessor {
    private UserAdministration _admin;
    private Class _userPrincipalClass;

    public JaasUserAccessor(UserAdministration aAdmin, String aUserClassName) {
        this._admin = aAdmin;
        try {
            this._userPrincipalClass = Class.forName(aUserClassName);
            if (!Principal.class.isAssignableFrom(this._userPrincipalClass)) {
                throw new IllegalArgumentException("Specified class '" + aUserClassName + "' is not a subclass of '" + Principal.class.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public User getCurrentUser() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            return null;
        }
        Principal userPrincipal = this.getUserPrincipal(subject);
        return this._admin.getUser(userPrincipal.getName());
    }

    private Principal getUserPrincipal(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Principal userPrincipal = null;
        for (Principal principal : principals) {
            if (!principal.getClass().equals(this._userPrincipalClass)) continue;
            if (userPrincipal != null) {
                throw new IllegalArgumentException("Multiple principals for class '" + this._userPrincipalClass + "', subject: " + subject);
            }
            userPrincipal = principal;
        }
        if (userPrincipal == null) {
            throw new IllegalArgumentException("No user principal found for class '" + this._userPrincipalClass + "', subject: " + subject);
        }
        return userPrincipal;
    }
}

