/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.wamblee.persistence.AbstractPersistent;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.UserMgtException;

public class User
extends AbstractPersistent
implements Serializable,
Comparable {
    private String _name;
    private String _password;
    private Set<Group> _groups;
    private NameValidator _passwordValidator;
    private MessageDigester _passwordEncoder;

    User(String aName, String aPassword, Group aGroup, NameValidator aPasswordValidator, MessageDigester aPasswordEncoder) throws UserMgtException {
        this._name = aName;
        aPasswordValidator.validate(aPassword);
        this._password = aPasswordEncoder.hash(aPassword);
        this._groups = new TreeSet<Group>();
        this._groups.add(aGroup);
        this._passwordValidator = aPasswordValidator;
        this._passwordEncoder = aPasswordEncoder;
    }

    public User(User aUser) {
        super((AbstractPersistent)aUser);
        this._name = aUser._name;
        this._password = aUser._password;
        this._groups = new TreeSet<Group>();
        for (Group group : aUser._groups) {
            this._groups.add(new Group(group));
        }
        this._passwordValidator = aUser._passwordValidator;
        this._passwordEncoder = aUser._passwordEncoder;
    }

    User() {
        this._name = null;
        this._password = null;
        this._groups = null;
        this._passwordValidator = null;
        this._passwordEncoder = null;
    }

    public void setPasswordValidator(NameValidator aPasswordValidator) {
        this._passwordValidator = aPasswordValidator;
    }

    public void setPasswordEncoder(MessageDigester aPasswordEncoder) {
        this._passwordEncoder = aPasswordEncoder;
    }

    String getPassword() {
        return this._password;
    }

    public void checkPassword(String aPassword) throws UserMgtException {
        String encoded = this._passwordEncoder.hash(aPassword);
        if (!this._password.equals(encoded)) {
            throw new UserMgtException(UserMgtException.Reason.INVALID_PASSWORD, this);
        }
    }

    public void changePassword(String aOldPassword, String aNewPassword) throws UserMgtException {
        this.checkPassword(aOldPassword);
        this._passwordValidator.validate(aNewPassword);
        this.setPassword(aNewPassword);
    }

    public void setPassword(String aPassword) throws UserMgtException {
        this._passwordValidator.validate(aPassword);
        this._password = this._passwordEncoder.hash(aPassword);
    }

    protected String getPasswordString() {
        return this._password;
    }

    protected void setPasswordString(String aPassword) {
        this._password = aPassword;
    }

    public String getName() {
        return this._name;
    }

    void setName(String aName) {
        this._name = aName;
    }

    public Set<Group> getGroups() {
        TreeSet<Group> result = new TreeSet<Group>();
        result.addAll(this._groups);
        return result;
    }

    public boolean isInGroup(Group aGroup) {
        return this._groups.contains(aGroup);
    }

    public boolean isInGroup(String aGroup) {
        return this._groups.contains(new Group(aGroup));
    }

    Set<Group> getGroupSet() {
        return this._groups;
    }

    void setGroupSet(Set<Group> aGroups) {
        this._groups = aGroups;
    }

    void addGroup(Group aGroup) throws UserMgtException {
        if (this._groups.contains(aGroup)) {
            throw new UserMgtException(UserMgtException.Reason.USER_ALREADY_IN_GROUP, aGroup);
        }
        this._groups.add(aGroup);
    }

    void removeGroup(Group aGroup) throws UserMgtException {
        if (!this._groups.contains(aGroup)) {
            throw new UserMgtException(UserMgtException.Reason.USER_NOT_IN_GROUP, this, aGroup);
        }
        if (this._groups.size() == 1) {
            throw new UserMgtException(UserMgtException.Reason.USER_MUST_BE_IN_A_GROUP, this, aGroup);
        }
        this._groups.remove(aGroup);
    }

    public boolean equals(Object aUser) {
        if (!(aUser instanceof User)) {
            return false;
        }
        User user = (User)aUser;
        return this._name.equals(user._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        String result = "User(name=" + this._name + ", password=" + this._password;
        for (Group group : this._groups) {
            result = result + ", group=" + group;
        }
        return result + ")";
    }

    public int compareTo(Object aUser) {
        return this._name.compareTo(((User)aUser)._name);
    }
}

