/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.UserAdministration;
import org.wamblee.usermgt.UserMgtException;

public class UserAdminInitializer {
    private static final Logger LOGGER = Logger.getLogger(UserAdminInitializer.class);

    public UserAdminInitializer(UserAdministration aAdmin, String[] aUsers, String[] aGroups, String[] aPasswords) throws UserMgtException, NoSuchAlgorithmException {
        if (aUsers.length != aGroups.length || aUsers.length != aPasswords.length) {
            throw new IllegalArgumentException("Array sizes for users, groups, and passwords differ: " + aUsers.length + "," + aGroups.length + "," + aPasswords.length);
        }
        if (aAdmin.getUserCount() == 0) {
            this.initialize(aAdmin, aUsers, aGroups, aPasswords);
        }
    }

    private void initialize(UserAdministration aAdmin, String[] aUsers, String[] aGroups, String[] aPasswords) throws UserMgtException {
        for (int i = 0; i < aUsers.length; ++i) {
            String user = aUsers[i];
            String group = aGroups[i];
            String password = aPasswords[i];
            if (aAdmin.getUser(user) != null) continue;
            Group groupObj = aAdmin.getGroup(group);
            if (groupObj == null) {
                LOGGER.info((Object)("Creating group: " + group));
                groupObj = aAdmin.createGroup(group);
            }
            assert (groupObj != null);
            LOGGER.info((Object)("Creating user: " + user + " password: " + password));
            aAdmin.createUser(user, password, groupObj);
        }
    }
}

