/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.util.Set;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.User;
import org.wamblee.usermgt.UserAdministration;
import org.wamblee.usermgt.UserMgtException;
import org.wamblee.usermgt.UserSet;

public class UserAdministrationImpl
implements UserAdministration {
    private UserSet _users;
    private GroupSet _groups;
    private NameValidator _userValidator;
    private NameValidator _groupValidator;

    public UserAdministrationImpl(UserSet aUsers, GroupSet aGroups, NameValidator aUserValidator, NameValidator aGroupValidator) {
        this._users = aUsers;
        this._groups = aGroups;
        this._userValidator = aUserValidator;
        this._groupValidator = aGroupValidator;
    }

    @Override
    public User createUser(String aUser, String aPassword, Group aGroup) throws UserMgtException {
        this._userValidator.validate(aUser);
        this.checkGroup(aGroup);
        User user = this._users.createUser(aUser, aPassword, aGroup);
        return new User(user);
    }

    @Override
    public Group createGroup(String aName) throws UserMgtException {
        this._groupValidator.validate(aName);
        Group group = new Group(aName);
        if (this._groups.contains(group)) {
            throw new UserMgtException(UserMgtException.Reason.DUPLICATE_GROUP, group);
        }
        this._groups.add(group);
        return new Group(group);
    }

    @Override
    public void userModified(User aUser) {
        this._users.userModified(aUser);
    }

    @Override
    public void groupModified(Group aGroup) {
        this._groups.groupModified(aGroup);
    }

    @Override
    public User getUser(String aName) {
        return this._users.find(aName);
    }

    @Override
    public Group getGroup(String aName) {
        return this._groups.find(aName);
    }

    @Override
    public Set<User> getUsers() {
        return this._users.list();
    }

    @Override
    public Set<User> getUsers(Group aGroup) {
        return this._users.list(aGroup);
    }

    @Override
    public Set<Group> getGroups() {
        return this._groups.list();
    }

    @Override
    public void removeUser(User aUser) throws UserMgtException {
        this.checkUser(aUser);
        this._users.remove(aUser);
    }

    @Override
    public void removeGroup(Group aGroup) throws UserMgtException {
        this.checkGroup(aGroup);
        if (this.getUsers(aGroup).size() > 0) {
            throw new UserMgtException(UserMgtException.Reason.GROUP_STILL_OCCUPIED, aGroup);
        }
        this._groups.remove(aGroup);
    }

    @Override
    public void renameUser(User aUser, String aUserName) throws UserMgtException {
        this.checkUser(aUser);
        if (aUser.getName().equals(aUserName)) {
            throw new UserMgtException(UserMgtException.Reason.TRIVIAL_RENAME, aUser);
        }
        if (this._users.find(aUserName) != null) {
            throw new UserMgtException(UserMgtException.Reason.DUPLICATE_USER, aUser);
        }
        this._userValidator.validate(aUserName);
        this._users.remove(aUser);
        aUser.setName(aUserName);
        this._users.add(aUser);
    }

    @Override
    public void renameGroup(Group aGroup, String aGroupName) throws UserMgtException {
        this.checkGroup(aGroup);
        if (aGroup.getName().equals(aGroupName)) {
            throw new UserMgtException(UserMgtException.Reason.TRIVIAL_RENAME, aGroup);
        }
        if (this._groups.find(aGroupName) != null) {
            throw new UserMgtException(UserMgtException.Reason.DUPLICATE_GROUP, aGroup);
        }
        this._groupValidator.validate(aGroupName);
        this._groups.remove(aGroup);
        aGroup.setName(aGroupName);
        this._groups.add(aGroup);
    }

    @Override
    public void addUserToGroup(User aUser, Group aGroup) throws UserMgtException {
        this.checkUser(aUser);
        this.checkGroup(aGroup);
        aUser.addGroup(aGroup);
        this._users.userModified(aUser);
    }

    @Override
    public void removeUserFromGroup(User aUser, Group aGroup) throws UserMgtException {
        this.checkUser(aUser);
        this.checkGroup(aGroup);
        aUser.removeGroup(aGroup);
        this._users.userModified(aUser);
    }

    private void checkUser(User aUser) throws UserMgtException {
        if (!this._users.contains(aUser)) {
            throw new UserMgtException(UserMgtException.Reason.UNKNOWN_USER, aUser);
        }
    }

    private void checkGroup(Group aGroup) throws UserMgtException {
        if (!this._groups.contains(aGroup)) {
            throw new UserMgtException(UserMgtException.Reason.UNKNOWN_GROUP, aGroup);
        }
    }

    @Override
    public int getUserCount() {
        return this._users.size();
    }

    @Override
    public int getGroupCount() {
        return this._groups.size();
    }
}

