/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt;

import java.util.EnumMap;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.User;

public class UserMgtException
extends Exception {
    static final long serialVersionUID = 5585349754997507529L;
    private static final EnumMap<Reason, String> MESSAGES = new EnumMap(Reason.class);
    private Reason _cause;
    private User _user;
    private Group _group;

    public UserMgtException(Reason aCause, String aMessage) {
        super(MESSAGES.get((Object)aCause) + ": " + aMessage);
        this._cause = aCause;
    }

    public UserMgtException(Reason aCause, User aUser) {
        this(aCause, "for user '" + aUser.getName() + "'");
        this._user = aUser;
    }

    public UserMgtException(Reason aCause, Group aGroup) {
        this(aCause, "for group '" + aGroup.getName() + "'");
        this._group = aGroup;
    }

    public UserMgtException(Reason aCause, User aUser, Group aGroup) {
        this(aCause, "for user '" + aUser.getName() + "' and group '" + aGroup.getName() + "'");
        this._user = aUser;
        this._group = aGroup;
    }

    public Reason getReason() {
        return this._cause;
    }

    public User getUser() {
        return this._user;
    }

    public Group getGroup() {
        return this._group;
    }

    static {
        MESSAGES.put(Reason.UNKNOWN_USER, "Unknown user");
        MESSAGES.put(Reason.UNKNOWN_GROUP, "Unknown group");
        MESSAGES.put(Reason.DUPLICATE_USER, "Duplicate user");
        MESSAGES.put(Reason.DUPLICATE_GROUP, "Duplicate group");
        MESSAGES.put(Reason.USER_ALREADY_IN_GROUP, "User already in group");
        MESSAGES.put(Reason.USER_NOT_IN_GROUP, "User not in group");
        MESSAGES.put(Reason.TRIVIAL_RENAME, "Trivial rename");
        MESSAGES.put(Reason.INVALID_PASSWORD, "Invalid password");
        MESSAGES.put(Reason.GROUP_STILL_OCCUPIED, "Group still occupied");
        MESSAGES.put(Reason.USER_MUST_BE_IN_A_GROUP, "User must be in at least one group");
        MESSAGES.put(Reason.INVALID_USERNAME, "Invalid user name");
        MESSAGES.put(Reason.INVALID_GROUPNAME, "Invalid group name");
    }

    public static enum Reason {
        UNKNOWN_USER,
        UNKNOWN_GROUP,
        DUPLICATE_USER,
        DUPLICATE_GROUP,
        USER_ALREADY_IN_GROUP,
        USER_NOT_IN_GROUP,
        TRIVIAL_RENAME,
        INVALID_PASSWORD,
        GROUP_STILL_OCCUPIED,
        USER_MUST_BE_IN_A_GROUP,
        INVALID_USERNAME,
        INVALID_GROUPNAME;

    }
}

