/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt.hibernate;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.wamblee.persistence.Persistent;
import org.wamblee.persistence.hibernate.HibernateSupport;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.GroupSet;

public class HibernateGroupSet
extends HibernateSupport
implements GroupSet {
    private static final String QUERY_FIND_BY_NAME = "findGroupByName";
    private static final String PARAM_NAME = "name";
    private static final String QUERY_COUNT_GROUPS = "countGroups";

    @Override
    public void groupModified(Group aGroup) {
        assert (aGroup.getPrimaryKey() != null);
        super.merge((Persistent)aGroup);
    }

    @Override
    public Group find(String aName) {
        List list = this.getHibernateTemplate().findByNamedQueryAndNamedParam(QUERY_FIND_BY_NAME, PARAM_NAME, (Object)aName);
        if (list.size() > 1) {
            throw new RuntimeException("More than one group with the same name '" + aName + "'");
        }
        if (list.size() == 0) {
            return null;
        }
        return new Group((Group)list.get(0));
    }

    @Override
    public boolean contains(Group aGroup) {
        return this.find(aGroup.getName()) != null;
    }

    @Override
    public boolean add(Group aGroup) {
        assert (aGroup.getPrimaryKey() == null);
        if (this.contains(aGroup)) {
            return false;
        }
        super.merge((Persistent)aGroup);
        return true;
    }

    @Override
    public boolean remove(Group aGroup) {
        assert (aGroup.getPrimaryKey() != null);
        if (!this.contains(aGroup)) {
            return false;
        }
        Group group = (Group)this.getHibernateTemplate().merge((Object)aGroup);
        this.getHibernateTemplate().delete((Object)group);
        aGroup.setPrimaryKey(null);
        aGroup.setPersistedVersion(-1);
        return true;
    }

    @Override
    public Set<Group> list() {
        TreeSet<Group> groups = new TreeSet<Group>();
        List list = this.getHibernateTemplate().loadAll(Group.class);
        for (Group group : list) {
            groups.add(new Group(group));
        }
        return groups;
    }

    @Override
    public int size() {
        Long result = (Long)this.getHibernateTemplate().findByNamedQuery(QUERY_COUNT_GROUPS).get(0);
        return result.intValue();
    }
}

