/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.usermgt.hibernate;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.wamblee.cache.Cache;
import org.wamblee.persistence.Persistent;
import org.wamblee.persistence.hibernate.HibernateSupport;
import org.wamblee.security.encryption.MessageDigester;
import org.wamblee.usermgt.AbstractUserSet;
import org.wamblee.usermgt.Group;
import org.wamblee.usermgt.NameValidator;
import org.wamblee.usermgt.User;

public class HibernateUserSet
extends AbstractUserSet {
    private static final String QUERY_FIND_BY_NAME = "findUserByName";
    private static final String QUERY_FIND_BY_GROUP_NAME = "findUserByGroupName";
    private static final String PARAM_NAME = "name";
    private static final String QUERY_COUNT_USERS = "countUsers";
    private Cache<String, User> _cache;
    private HibernateSupport _hibernateSupport;

    public HibernateUserSet(Cache<String, User> aCache, NameValidator aPasswordValidator, MessageDigester aPasswordEncoder) {
        super(aPasswordValidator, aPasswordEncoder);
        this._cache = aCache;
        this._hibernateSupport = new HibernateSupport();
    }

    public void setSessionFactory(SessionFactory aFactory) {
        this._hibernateSupport.setSessionFactory(aFactory);
    }

    private HibernateTemplate getHibernateTemplate() {
        return this._hibernateSupport.getHibernateTemplate();
    }

    @Override
    public void userModified(User aUser) {
        assert (aUser.getPrimaryKey() != null);
        this._hibernateSupport.merge((Persistent)aUser);
        this._cache.remove((Serializable)((Object)aUser.getName()));
        this.setPasswordInfo(aUser);
        this._cache.put((Serializable)((Object)aUser.getName()), (Serializable)new User(aUser));
    }

    @Override
    public User find(String aName) {
        User user = (User)this._cache.get((Serializable)((Object)aName));
        if (user != null) {
            return user;
        }
        List result = this.getHibernateTemplate().findByNamedQueryAndNamedParam(QUERY_FIND_BY_NAME, PARAM_NAME, (Object)aName);
        if (result.size() > 1) {
            throw new RuntimeException("Implementation problem, more than one user with the same name!");
        }
        if (result.size() == 0) {
            return null;
        }
        user = (User)result.get(0);
        this.setPasswordInfo(user);
        this._cache.put((Serializable)((Object)aName), (Serializable)user);
        return new User(user);
    }

    @Override
    public boolean contains(User aUser) {
        return this.find(aUser.getName()) != null;
    }

    @Override
    public boolean add(User aUser) {
        assert (aUser.getPrimaryKey() == null);
        if (this.contains(aUser)) {
            return false;
        }
        this.getHibernateTemplate().saveOrUpdate((Object)aUser);
        this.setPasswordInfo(aUser);
        this._cache.put((Serializable)((Object)aUser.getName()), (Serializable)aUser);
        return true;
    }

    @Override
    public boolean remove(User aUser) {
        assert (aUser.getPrimaryKey() != null);
        if (!this.contains(aUser)) {
            return false;
        }
        User user = (User)this.getHibernateTemplate().merge((Object)aUser);
        this.getHibernateTemplate().delete((Object)user);
        aUser.setPersistedVersion(-1);
        aUser.setPrimaryKey(null);
        this._cache.remove((Serializable)((Object)aUser.getName()));
        return true;
    }

    @Override
    public Set<User> list() {
        TreeSet<User> users = new TreeSet<User>();
        List list = this.getHibernateTemplate().loadAll(User.class);
        for (User user : list) {
            this.setPasswordInfo(user);
            users.add(new User(user));
        }
        return users;
    }

    @Override
    public Set<User> list(Group aGroup) {
        TreeSet<User> users = new TreeSet<User>();
        List list = this.getHibernateTemplate().findByNamedQueryAndNamedParam(QUERY_FIND_BY_GROUP_NAME, PARAM_NAME, (Object)aGroup.getName());
        for (User user : list) {
            this.setPasswordInfo(user);
            users.add(new User(user));
        }
        return users;
    }

    @Override
    public int size() {
        Long result = (Long)this.getHibernateTemplate().findByNamedQuery(QUERY_COUNT_USERS).get(0);
        return result.intValue();
    }
}

