/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.collections;

import java.util.Collection;

import org.wamblee.conditions.Condition;

public class CollectionFilter {

    /**
     * Filters a collection by adding all elements in the from collection 
     * that satisfy a given condition to the to collection. 
     * @param <T> Type of contained element. 
     * @param aFrom From container to which the condition is applied. 
     * @param aTo To container to which matching elements are added. 
     * @param aCondition Condition by which elements are matched. 
     */
	public static <T> void filter(Collection<T> aFrom, Collection<T> aTo, Condition<T> aCondition) { 
		for (T t: aFrom) { 
			if ( aCondition.matches(t)) { 
				aTo.add(t);
			}
		}
	}
	
}
