/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.general;

/**
 * Bean factory used to obtain objects in a transparent way. 
 *
 * @author Erik Brakkee
 */
public interface BeanFactory {

    /**
     * Finds a bean based on id. 
     * @param aId Id of the bean. 
     * @return Object  (always non-null). 
     * @throws BeanFactoryException In case the object could not be found. 
     */
    Object find(String aId);  
    
    /**
     * Finds a bean of the given class and which can be cast to the 
     * specified class. This is typically used by specifying the interface
     * class for retrieving an implementation of that class. This 
     * means that the bean implementing the class is configured in the bean factory
     * with id equal to the class name of the interface.  
     * @param aClass Class of the object to find. 
     * @return Object (always non-null).
     * @throws BeanFactoryException In case the object could not be found. 
     */
     <T> T find(Class<T> aClass);
     
     /**
      * Finds a bean with the given id which can be cast to the specified
      * class.  
      * @param <T> Type of the object to get. 
      * @param aId Id of the object to lookup. 
      * @param aClass Class that the object must extends. 
      * @return Object, always non-null. 
      * @throws BeanFactoryException In case the object could not be found. 
      */
     <T> T find(String aId, Class<T> aClass); 
}
