


/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.general;

/**
 * Represents a pair of objects. This is inspired on the C++ Standard Template
 * Library pair template.
 * 
 * @param <T>
 *            Type of the first object.
 * @param <U>
 *            Type of the second object.
 *
 * @author Erik Brakkee
 */
public class Pair<T, U> {

    private T _t;

    private U _u;

    /**
     * Constructs the pair.
     * 
     * @param aT
     *            First object.
     * @param aU
     *            Second object.
     */
    public Pair(T aT, U aU) {
        _t = aT;
        _u = aU;
    }

    /**
     * Copies a pair.
     * 
     * @param aPair
     *            Pair to copy.
     */
    public Pair(Pair<T, U> aPair) {
        _t = aPair._t;
        _u = aPair._u;
    }

    /**
     * Gets the first object of the pair.
     * 
     * @return First object.
     */
    public T getFirst() {
        return _t;
    }

    /**
     * Gets the second object of the pair.
     * 
     * @return Second object.
     */
    public U getSecond() {
        return _u;
    }

}
