/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * Represents an input resource in the classpath.
 */
public class ClassPathResource implements InputResource {
    /**
     * Resource name.
     */
    private String _resource;

    /**
     * Construct the class path resource.
     * 
     * @param aResource
     *            Resource
     */
    public ClassPathResource(String aResource) {
        _resource = aResource;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.io.InputResource#getInputStream()
     */
    public InputStream getInputStream() throws IOException {
        InputStream stream = Thread.currentThread().getContextClassLoader()
                .getResourceAsStream(_resource);
        if (stream == null) {
            throw new IOException("Class path resource '" + _resource
                    + "' not found.");
        }
        return stream;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "ClassPathResource(" + _resource + ")";
    }
}
