/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.persistence;

import java.io.Serializable;

/**
 * Default implementation of Persistent. 
 *
 * @author Erik Brakkee
 */
public abstract class AbstractPersistent implements Persistent {
    
    /**
     * Primary key. 
     */
    private Serializable _primaryKey; 
    
    /**
     * Version. 
     */
    private int _version; 
    
    /**
     * Constructs the object. 
     *
     */
    protected AbstractPersistent() { 
        _primaryKey = null; 
        _version = -1; 
    }
    
    /**
     * Copy constructor. 
     * @param aPersistent Object to copy. 
     */
    protected AbstractPersistent(AbstractPersistent aPersistent) {
        _primaryKey = aPersistent._primaryKey; 
        _version = aPersistent._version; 
    }

    /* (non-Javadoc)
     * @see org.wamblee.persistence.Persistent#getPrimaryKey()
     */
    public Serializable getPrimaryKey() {
        return _primaryKey; 
    }
    
    /* (non-Javadoc)
     * @see org.wamblee.persistence.Persistent#setPrimaryKey(java.io.Serializable)
     */
    public void setPrimaryKey(Serializable aKey) {
        _primaryKey = aKey; 
    }
    
    /* (non-Javadoc)
     * @see org.wamblee.persistence.Persistent#getPersistedVersion()
     */
    public int getPersistedVersion() {
        return _version; 
    }
    
    /* (non-Javadoc)
     * @see org.wamblee.persistence.Persistent#setPersistedVersion(int)
     */
    public void setPersistedVersion(int aVersion) {
        _version = aVersion;
    }
}
