/*
 * Copyright 2005 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

package org.wamblee.persistence;

import java.io.Serializable;

/**
 * Interface for persistent objects. This defines required functionality for all objects
 * that are persisted. 
 * 
 * Objects that implement this interface and which implement 
 * {@link java.lang.Object#equals(java.lang.Object)}
 * should exclude the primary key and version from determining equality. 
 */
public interface Persistent {

    /**
     * Gets the primary key. 
     * @return Primary key.
     * @see #setPrimaryKey(Serializable) 
     */
    Serializable getPrimaryKey(); 
    
    /**
     * Sets the primary key. 
     * @param aKey Primary key.
     * @see #getPrimaryKey() 
     */
    void setPrimaryKey(Serializable aKey); 
    
    /**
     * Gets the version. 
     * @return Version. 
     * @see #setPersistedVersion(int)
     */
    int getPersistedVersion(); 
    
    /**
     * Sets the version. 
     * @param aVersion Version. 
     * @see #getPersistedVersion()
     */
    void setPersistedVersion(int aVersion); 
}
