package org.wamblee.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectionUtils {

	/**
	 * Wraps a type by the corresponding wrapper type if it is a primitive
	 * type.
	 * @param aClass Type to wrap. 
	 * @return Wrapped type for primitives or the provided argument value. 
	 */
	public static Class wrapIfNeeded(Class aClass) {

		if (aClass == boolean.class) {
			return Boolean.class;
		}
		if (aClass == byte.class) {
			return Byte.class;
		}
		if (aClass == char.class) {
			return Character.class;
		}
		if (aClass == short.class) {
			return Short.class;
		}
		if (aClass == int.class) {
			return Integer.class;
		}
		if (aClass == long.class) {
			return Long.class;
		}
		if (aClass == float.class) {
			return Float.class;
		}
		if (aClass == double.class) {
			return Double.class;
		}
		if (aClass == void.class) {
			return Void.class;
		}
		return aClass;
	}
	
	
	public static List<Method> getAllMethods(Class aClass) {
		
		Map<String,Method> found = new HashMap<String, Method>();
		getAllMethods(aClass, found);
		return new ArrayList<Method>(found.values());
	}

	private static void getAllMethods(Class aClass, Map<String,Method> aFound) { 
		List<Method> declared = Arrays.asList(aClass.getDeclaredMethods());
		for (Method method: declared) { 
			Method superMethod = aFound.get(method.getName());
			if ( superMethod == null ) { 
				// no superclass method
				aFound.put(method.getName(), method);
			}
			else { 
				// super class method. Check for override.
				if ( !Arrays.equals(superMethod.getParameterTypes(), method.getParameterTypes())) { 
					// parameters differ so this is a new method.
					aFound.put(method.getName(), method);
				}
			}
		}
		Class superClass = aClass.getSuperclass();
		if (superClass != null) {
			getAllMethods(superClass, aFound);
		}
	}
}
