/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.IOException;
import java.io.Serializable;
import junit.framework.TestCase;
import net.sf.ehcache.CacheException;
import org.wamblee.cache.Cache;
import org.wamblee.cache.CachedObject;
import org.wamblee.cache.EhCache;
import org.wamblee.cache.ForeverCache;
import org.wamblee.cache.ZeroCache;
import org.wamblee.io.InputResource;
import org.wamblee.io.TestResource;
import org.wamblee.test.TimingUtils;

public class CachedObjectTest
extends TestCase {
    private static final String EHCACHE_CONFIG = "ehcache.xml";
    private static final int OBJECT_KEY = 10;
    private CachedObject.Computation<Integer, Integer> _computation;
    private int _ncomputations;

    protected void setUp() throws Exception {
        super.setUp();
        this._computation = new CachedObject.Computation<Integer, Integer>(){

            public Integer getObject(Integer aObjectKey) {
                CachedObjectTest.this._ncomputations++;
                return CachedObjectTest.this.compute(aObjectKey);
            }
        };
        this._ncomputations = 0;
    }

    private int compute(int aValue) {
        return aValue + 10;
    }

    private CachedObject<Integer, Integer> createCached(Cache<Integer, Integer> aCache) {
        return new CachedObject(aCache, (Serializable)Integer.valueOf(10), this._computation);
    }

    public void testComputation() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
    }

    public void testInvalidateCache() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ForeverCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        cached.invalidate();
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this._ncomputations);
    }

    public void testBehaviorEhCache() throws CacheException, IOException {
        EhCache cache = new EhCache((InputResource)new TestResource(CachedObjectTest.class, EHCACHE_CONFIG), "test");
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)cache);
        CachedObjectTest.assertTrue((cache == cached.getCache() ? 1 : 0) != 0);
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        TimingUtils.sleep(6000);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this._ncomputations);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this._ncomputations);
        cached.invalidate();
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)3, (int)this._ncomputations);
    }

    public void testBehaviorEhCacheDefault() throws CacheException, IOException {
        EhCache cache = new EhCache((InputResource)new TestResource(CachedObjectTest.class, EHCACHE_CONFIG), "undefined");
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)cache);
        CachedObjectTest.assertTrue((cache == cached.getCache() ? 1 : 0) != 0);
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        TimingUtils.sleep(6000);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this._ncomputations);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this._ncomputations);
    }

    public void testBehaviorForeverCache() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ForeverCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        for (int ncomp = 2; ncomp <= 100; ++ncomp) {
            value = (Integer)cached.get();
            CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
            CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        }
    }

    public void testBehaviorZeroCache() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this._ncomputations);
        for (int ncomp = 2; ncomp <= 100; ++ncomp) {
            value = (Integer)cached.get();
            CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
            CachedObjectTest.assertEquals((int)ncomp, (int)this._ncomputations);
        }
        cached.invalidate();
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)101, (int)this._ncomputations);
    }
}

