/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import junit.framework.TestCase;
import org.wamblee.concurrency.ReadLocker;
import org.wamblee.concurrency.ReadWriteLock;
import org.wamblee.concurrency.WriteLocker;

public class ReadWriteLockTest
extends TestCase {
    private static final int HALF_SECOND = 500;
    private static final int ONE_SECOND = 1000;
    private static final int TWO_SECONDS = 2000;
    private ReadWriteLock _lock;
    private int _nReaders;
    private int _nWriters;

    public ReadWriteLockTest(String aName) {
        super(aName);
    }

    private synchronized int getReaderCount() {
        return this._nReaders;
    }

    private synchronized int getWriterCount() {
        return this._nWriters;
    }

    synchronized void incrementReaderCount() {
        ++this._nReaders;
    }

    synchronized void incrementWriterCount() {
        ++this._nWriters;
    }

    synchronized void decrementReaderCount() {
        --this._nReaders;
    }

    synchronized void decrementWriterCount() {
        --this._nWriters;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._lock = new ReadWriteLock();
    }

    protected void tearDown() throws Exception {
        this._lock = null;
        super.tearDown();
    }

    public void testRead() {
        this._lock.acquireRead();
        this._lock.releaseRead();
    }

    public void testWrite() {
        this._lock.acquireWrite();
        this._lock.releaseWrite();
    }

    public void testMultipleReaders() throws InterruptedException {
        ReadLocker runnable = new ReadLocker(this._lock, this, 2000);
        Thread t1 = new Thread(runnable);
        t1.start();
        Thread t2 = new Thread(runnable);
        t2.start();
        Thread.sleep(1000L);
        ReadWriteLockTest.assertTrue((String)"Not enough readers!", (this.getReaderCount() == 2 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testSingleWriter() throws InterruptedException {
        WriteLocker writer = new WriteLocker(this._lock, this, 1000);
        Thread t1 = new Thread(writer);
        Thread t2 = new Thread(writer);
        t1.start();
        t2.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((String)("Wrong writer count: " + this.getWriterCount()), (this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testMultipleWriters() throws InterruptedException {
        WriteLocker writer1 = new WriteLocker(this._lock, this, 1500);
        WriteLocker writer2 = new WriteLocker(this._lock, this, 1000);
        Thread t1 = new Thread(writer1);
        Thread t2 = new Thread(writer2);
        t1.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t2.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testReadWrite1() throws InterruptedException {
        ReadLocker readLocker = new ReadLocker(this._lock, this, 2000);
        Thread t1 = new Thread(readLocker);
        WriteLocker writeLocker = new WriteLocker(this._lock, this, 2000);
        Thread t2 = new Thread(writeLocker);
        t1.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        t2.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(1500L);
        ReadWriteLockTest.assertTrue((String)("Wrong no. of readers: " + this.getReaderCount()), (this.getReaderCount() == 0 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testReadWrite2() throws InterruptedException {
        ReadLocker readLocker1 = new ReadLocker(this._lock, this, 2500);
        ReadLocker readLocker2 = new ReadLocker(this._lock, this, 2500);
        Thread t1 = new Thread(readLocker1);
        Thread t2 = new Thread(readLocker2);
        WriteLocker writeLocker = new WriteLocker(this._lock, this, 2000);
        Thread t3 = new Thread(writeLocker);
        t1.start();
        Thread.sleep(1000L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        t2.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 2 ? 1 : 0) != 0);
        t3.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 2 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 0 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
        t3.join();
    }

    public void testReadWrite3() throws InterruptedException {
        ReadLocker readLocker = new ReadLocker(this._lock, this, 2000);
        Thread t1 = new Thread(readLocker);
        WriteLocker writeLocker = new WriteLocker(this._lock, this, 2000);
        Thread t2 = new Thread(writeLocker);
        t2.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.start();
        Thread.sleep(500L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(1500L);
        ReadWriteLockTest.assertTrue((String)("Wrong no. of writers: " + this.getReaderCount()), (this.getWriterCount() == 0 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseReadFromWrongThread() throws InterruptedException {
        Thread t1 = null;
        try {
            t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    ReadWriteLockTest.this._lock.acquireRead();
                }
            });
            t1.start();
            Thread.sleep(1000L);
            this._lock.releaseRead();
        }
        catch (RuntimeException e) {
            return;
        }
        finally {
            t1.join();
        }
        ReadWriteLockTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseWriteFromWrongThread() throws InterruptedException {
        Thread t1 = null;
        try {
            t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    ReadWriteLockTest.this._lock.acquireWrite();
                }
            });
            t1.start();
            Thread.sleep(1000L);
            this._lock.releaseWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        finally {
            t1.join();
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireReadTwice() {
        try {
            this._lock.acquireRead();
            this._lock.acquireRead();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireWriteTwice() {
        try {
            this._lock.acquireWrite();
            this._lock.acquireWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireReadFollowedByWrite() {
        try {
            this._lock.acquireRead();
            this._lock.acquireWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireWriteFollowedByRead() {
        try {
            this._lock.acquireWrite();
            this._lock.acquireRead();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireReadFollowedByReleaseaWrite() {
        try {
            this._lock.acquireRead();
            this._lock.releaseWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireWriteFollowedByReleaseRead() {
        try {
            this._lock.acquireWrite();
            this._lock.releaseRead();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }
}

