/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.FileFilter;
import junit.framework.TestCase;
import org.apache.oro.io.AwkFilenameFilter;
import org.mockito.Mockito;
import org.wamblee.io.DirectoryMonitor;
import org.wamblee.io.TestData;

public class DirectoryMonitorTest
extends TestCase {
    private static final String REGEX = "^.*\\.txt$";
    private static final String FILE1 = "file1.txt";
    private TestData _data;
    private DirectoryMonitor.Listener _listener;
    private DirectoryMonitor _monitor;

    protected void setUp() throws Exception {
        super.setUp();
        this._data = new TestData((Object)this);
        this._data.clean();
        this._listener = (DirectoryMonitor.Listener)Mockito.mock(DirectoryMonitor.Listener.class);
        this._monitor = new DirectoryMonitor(this._data.getRoot(), (FileFilter)new AwkFilenameFilter(REGEX), this._listener);
    }

    public void testEmptyDir() {
        for (int i = 0; i < 10; ++i) {
            this._monitor.poll();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this._listener});
        }
    }

    public void testFileCreated() {
        this._data.createFile(FILE1, "hello");
        this._monitor.poll();
        ((DirectoryMonitor.Listener)Mockito.verify((Object)this._listener)).fileCreated(this._data.getFile(FILE1));
    }

    public void testFileDeleted() {
        this._data.createFile(FILE1, "hello");
        this._monitor.poll();
        Mockito.reset((Object[])new DirectoryMonitor.Listener[]{this._listener});
        this._data.deleteFile(FILE1);
        this._monitor.poll();
        ((DirectoryMonitor.Listener)Mockito.verify((Object)this._listener)).fileDeleted(this._data.getFile(FILE1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this._listener});
    }

    public void testFileChanged() throws InterruptedException {
        this._data.createFile(FILE1, "hello");
        this._monitor.poll();
        Mockito.reset((Object[])new DirectoryMonitor.Listener[]{this._listener});
        Thread.sleep(2000L);
        this._data.deleteFile(FILE1);
        this._data.createFile(FILE1, "bla");
        this._monitor.poll();
        ((DirectoryMonitor.Listener)Mockito.verify((Object)this._listener)).fileChanged(this._data.getFile(FILE1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this._listener});
    }

    public void testFileFilterIsUsed() {
        this._monitor.poll();
        this._data.createFile("file.xml", "hello");
        this._monitor.poll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this._listener});
    }

    public void testDirectoryIsIgnored() {
        this._monitor.poll();
        this._data.createDir(FILE1);
        this._monitor.poll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this._listener});
    }

    public void testExceptionsWIllLeadToRepeatedNotifications() {
        this._monitor.poll();
        this._data.createFile(FILE1, "hello");
        ((DirectoryMonitor.Listener)Mockito.stubVoid((Object)this._listener).toThrow((Throwable)new RuntimeException()).on()).fileCreated(this._data.getFile(FILE1));
        try {
            this._monitor.poll();
        }
        catch (RuntimeException e) {
            Mockito.reset((Object[])new DirectoryMonitor.Listener[]{this._listener});
            this._monitor.poll();
            ((DirectoryMonitor.Listener)Mockito.verify((Object)this._listener)).fileCreated(this._data.getFile(FILE1));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this._listener});
            return;
        }
        DirectoryMonitorTest.fail();
    }
}

